/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.util;

import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.crafting.ICraftingRecipeList;
import ic2.core.IC2;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import trinsdar.gravisuit.util.Config;
import trinsdar.gravisuit.util.FlagModifierMetaLess;
import trinsdar.gravisuit.util.Registry;

public class GravisuitRecipes {
    static ICraftingRecipeList recipes = ClassicRecipes.advCrafting;

    public static void init() {
        GravisuitRecipes.initShapedRecipes();
        GravisuitRecipes.initOverrideRecipes();
    }

    static ICraftingRecipeList.IRecipeModifier treetap() {
        return new ICraftingRecipeList.IRecipeModifier(){
            String id = "Import";
            boolean tag = false;

            public void clear() {
                this.tag = false;
            }

            public boolean isStackValid(ItemStack provided) {
                NBTTagCompound nbt;
                if (StackUtil.isStackEqual((ItemStack)Ic2Items.electricTreeTap, (ItemStack)provided) && (nbt = StackUtil.getNbtData((ItemStack)provided)).func_74767_n(this.id)) {
                    this.tag = true;
                }
                return true;
            }

            public ItemStack getOutput(ItemStack output, boolean forDisplay) {
                if (forDisplay) {
                    StackUtil.addToolTip((ItemStack)output, (String)"Upgrades get transfered");
                } else {
                    NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)output);
                    if (this.tag) {
                        nbt.func_74757_a(this.id, true);
                    }
                }
                return output;
            }

            public boolean isOutput(ItemStack possibleOutput) {
                return false;
            }
        };
    }

    static ICraftingRecipeList.IRecipeModifier wrench(final ItemStack provided) {
        return new ICraftingRecipeList.IRecipeModifier(){

            public void clear() {
            }

            public boolean isStackValid(ItemStack itemStack) {
                if (StackUtil.isStackEqual((ItemStack)provided, (ItemStack)itemStack)) {
                    NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)itemStack);
                    return nbt.func_74767_n("Lossless");
                }
                return true;
            }

            public ItemStack getOutput(ItemStack itemStack, boolean b) {
                return new ItemStack((Item)Registry.gravitool);
            }

            public boolean isOutput(ItemStack itemStack) {
                return false;
            }
        };
    }

    public static void initShapedRecipes() {
        if (Config.enableMiscCraftingItems) {
            recipes.addRecipe(new ItemStack((Item)Registry.superConductorCover, 3), new Object[]{"AIA", "CCC", "AIA", Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('C'), Ic2Items.carbonPlate});
            recipes.addRecipe(new ItemStack((Item)Registry.superConductor, 3), new Object[]{"SSS", "GUG", "SSS", Character.valueOf('S'), Registry.superConductorCover, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('U'), Ic2Items.uuMatter});
            recipes.addRecipe(new ItemStack((Item)Registry.coolingCore), new Object[]{"CAC", "HIH", "CAC", Character.valueOf('C'), Ic2Items.reactorCoolantCellSix, Character.valueOf('A'), Ic2Items.reactorHeatSwitchDiamond, Character.valueOf('H'), Ic2Items.reactorPlatingHeat, Character.valueOf('I'), Ic2Items.iridiumPlate});
            recipes.addRecipe(new ItemStack((Item)Registry.gravitationEngine), new Object[]{"TST", "CIC", "TST", Character.valueOf('T'), Ic2Items.teslaCoil, Character.valueOf('S'), Registry.superConductor, Character.valueOf('C'), Registry.coolingCore, Character.valueOf('I'), Ic2Items.transformerIV});
            recipes.addRecipe(new ItemStack((Item)Registry.magnetron), new Object[]{"ICI", "CSC", "ICI", Character.valueOf('I'), IC2.getRefinedIron(), Character.valueOf('C'), "ingotCopper", Character.valueOf('S'), Registry.superConductor});
            recipes.addRecipe(new ItemStack((Item)Registry.vajraCore), new Object[]{" M ", "ITI", "StS", Character.valueOf('M'), Registry.magnetron, Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('T'), Ic2Items.teslaCoil, Character.valueOf('S'), Registry.superConductor, Character.valueOf('t'), Ic2Items.transformerIV});
            recipes.addRecipe(new ItemStack((Item)Registry.engineBoost), new Object[]{"GAG", "COC", "AHA", Character.valueOf('G'), "dustGlowstone", Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('C'), "circuitAdvanced", Character.valueOf('O'), Ic2Items.overClockerUpgrade, Character.valueOf('H'), Ic2Items.reactorVentDiamond});
        }
        if (Config.enableMiscCraftingItems && Config.enableUltimateLappack) {
            recipes.addRecipe(new ItemStack((Item)Registry.getUltimateLappack()), new Object[]{"LIL", "LQL", "LSL", Character.valueOf('L'), Ic2Items.lapotronCrystal, Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('Q'), Ic2Items.quantumPack, Character.valueOf('S'), Registry.superConductor});
        }
        if (Config.enableAdvancedLappack) {
            recipes.addRecipe(new ItemStack((Item)Registry.getAdvancedLappack()), new Object[]{"L", "A", "C", Character.valueOf('L'), Ic2Items.lapPack, Character.valueOf('A'), "circuitAdvanced", Character.valueOf('C'), Ic2Items.lapotronCrystal});
        }
        if (Config.enableAdvancedElectricJetpack && Config.enableMiscCraftingItems && Config.enableAdvancedLappack) {
            recipes.addRecipe(new ItemStack((Item)Registry.getAdvancedElectricJetpack()), new Object[]{"CEC", "BLB", "GAG", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('E'), Ic2Items.electricJetpack, Character.valueOf('B'), Registry.engineBoost, Character.valueOf('L'), Registry.getAdvancedLappack(), Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('A'), "circuitAdvanced"});
        }
        if (Config.enableAdvancedNuclearJetpack && Config.enableMiscCraftingItems && Config.enableAdvancedLappack) {
            recipes.addRecipe(new ItemStack((Item)Registry.getAdvancedNuclearJetpack()), new Object[]{"CEC", "BLB", "GAG", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('E'), Ic2Items.nuclearJetpack, Character.valueOf('B'), Registry.engineBoost, Character.valueOf('L'), Registry.getAdvancedLappack(), Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('A'), "circuitAdvanced"});
            if (Config.enableAdvancedElectricJetpack) {
                recipes.addRecipe(new ItemStack((Item)Registry.getAdvancedNuclearJetpack()), new Object[]{"CTC", "RNR", "CAC", Character.valueOf('C'), "circuitBasic", Character.valueOf('T'), Ic2Items.transformerEV, Character.valueOf('R'), Ic2Items.reactorChamber, Character.valueOf('N'), Ic2Items.nuclearReactor, Character.valueOf('A'), Registry.getAdvancedElectricJetpack()});
            }
        }
        if (Config.enableMiscCraftingItems && Config.enableGravisuit && Config.enableAdvancedNanoChestplate && Config.enableUltimateLappack) {
            if (GravisuitRecipes.areOverrideRecipesValid()) {
                recipes.addRecipe(new ItemStack((Item)Registry.gravisuit), new Object[]{"SQS", "GTG", "SUS", Character.valueOf('S'), Registry.superConductor, Character.valueOf('Q'), Ic2Items.quantumJetplate, Character.valueOf('G'), Registry.gravitationEngine, Character.valueOf('T'), Ic2Items.transformerEV, Character.valueOf('U'), Registry.getUltimateLappack()});
            } else {
                recipes.addRecipe(new ItemStack((Item)Registry.gravisuit), new Object[]{"SQS", "GAG", "SUS", Character.valueOf('S'), Registry.superConductor, Character.valueOf('Q'), Ic2Items.quantumJetplate, Character.valueOf('G'), Registry.gravitationEngine, Character.valueOf('A'), Registry.advancedNanoChestplate, Character.valueOf('U'), Registry.getUltimateLappack()});
            }
        }
        if (Config.enableMiscCraftingItems && Config.enableNuclearGravisuit && Config.enableAdvancedNuclearNanoChestplate && Config.enableUltimateLappack) {
            if (Config.enableGravisuit) {
                recipes.addRecipe(new ItemStack((Item)Registry.nuclearGravisuit), new Object[]{"CTC", "RNR", "CAC", Character.valueOf('C'), "circuitBasic", Character.valueOf('T'), Ic2Items.transformerEV, Character.valueOf('R'), Ic2Items.reactorChamber, Character.valueOf('N'), Ic2Items.nuclearReactor, Character.valueOf('A'), Registry.gravisuit});
            }
            if (GravisuitRecipes.areOverrideRecipesValid()) {
                recipes.addRecipe(new ItemStack((Item)Registry.nuclearGravisuit), new Object[]{"SQS", "GTG", "SUS", Character.valueOf('S'), Registry.superConductor, Character.valueOf('Q'), Ic2Items.quantumNuclearJetplate, Character.valueOf('G'), Registry.gravitationEngine, Character.valueOf('T'), Ic2Items.transformerEV, Character.valueOf('U'), Registry.getUltimateLappack()});
            } else {
                recipes.addRecipe(new ItemStack((Item)Registry.nuclearGravisuit), new Object[]{"SQS", "GAG", "SUS", Character.valueOf('S'), Registry.superConductor, Character.valueOf('Q'), Ic2Items.quantumNuclearJetplate, Character.valueOf('G'), Registry.gravitationEngine, Character.valueOf('A'), Registry.advancedNuclearNanoChestplate, Character.valueOf('U'), Registry.getUltimateLappack()});
            }
        }
        if (Config.enableAdvancedNanoChestplate && Config.enableAdvancedElectricJetpack) {
            if (GravisuitRecipes.areOverrideRecipesValid()) {
                recipes.addRecipe(new ItemStack((Item)Registry.advancedNanoChestplate), new Object[]{"CAC", "CNC", "GcG", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('A'), Ic2Items.compactedElectricJetpack, Character.valueOf('N'), Ic2Items.nanoChest, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('c'), "circuitAdvanced"});
            } else {
                recipes.addRecipe(new ItemStack((Item)Registry.advancedNanoChestplate), new Object[]{"CAC", "CNC", "GcG", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('A'), Registry.getAdvancedElectricJetpack(), Character.valueOf('N'), Ic2Items.nanoChest, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('c'), "circuitAdvanced"});
            }
        }
        if (Config.enableAdvancedNuclearNanoChestplate && Config.enableAdvancedNuclearJetpack) {
            if (Config.enableAdvancedNanoChestplate) {
                recipes.addRecipe(new ItemStack((Item)Registry.advancedNuclearNanoChestplate), new Object[]{"CTC", "RNR", "CAC", Character.valueOf('C'), "circuitBasic", Character.valueOf('T'), Ic2Items.transformerEV, Character.valueOf('R'), Ic2Items.reactorChamber, Character.valueOf('N'), Ic2Items.nuclearReactor, Character.valueOf('A'), Registry.advancedNanoChestplate});
            }
            if (GravisuitRecipes.areOverrideRecipesValid()) {
                recipes.addRecipe(new ItemStack((Item)Registry.advancedNuclearNanoChestplate), new Object[]{"CAC", "CNC", "GcG", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('A'), Ic2Items.compactedNuclearJetpack, Character.valueOf('N'), Ic2Items.nanoChest, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('c'), "circuitAdvanced"});
            } else {
                recipes.addRecipe(new ItemStack((Item)Registry.advancedNuclearNanoChestplate), new Object[]{"CAC", "CNC", "GcG", Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('A'), Registry.getAdvancedNuclearJetpack(), Character.valueOf('N'), Ic2Items.nanoChest, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('c'), "circuitAdvanced"});
            }
        }
        if (Config.enableGravitool) {
            recipes.addShapelessRecipe(new ItemStack((Item)Registry.gravitool), new Object[]{new FlagModifierMetaLess(new ItemStack((Item)Registry.gravitool), "Import", true).setUsesInput(), Registry.gravitool, Blocks.field_150438_bZ, Ic2Items.importBasicUpgrade.func_77946_l()});
            if (Config.enableGravitoolRequiresLosslessPrecisionWrench) {
                recipes.addRecipe(new ItemStack((Item)Registry.gravitool), new Object[]{"CHC", "AEA", "WaT", GravisuitRecipes.wrench(Ic2Items.precisionWrench), GravisuitRecipes.treetap(), Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('H'), Ic2Items.electricHoe, Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('E'), Ic2Items.energyCrystal, Character.valueOf('W'), Ic2Items.precisionWrench, Character.valueOf('a'), "circuitAdvanced", Character.valueOf('T'), Ic2Items.electricTreeTap});
            } else {
                recipes.addRecipe(new ItemStack((Item)Registry.gravitool), new Object[]{"CHC", "AEA", "WaT", GravisuitRecipes.treetap(), Character.valueOf('C'), Ic2Items.carbonPlate, Character.valueOf('H'), Ic2Items.electricHoe, Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('E'), Ic2Items.energyCrystal, Character.valueOf('W'), Ic2Items.precisionWrench, Character.valueOf('a'), "circuitAdvanced", Character.valueOf('T'), Ic2Items.electricTreeTap});
            }
        }
        if (Config.enableAdvancedDrill) {
            recipes.addRecipe(new ItemStack((Item)Registry.advancedDiamondDrill), new Object[]{"ODO", "AOA", Character.valueOf('O'), StackUtil.copyWithSize((ItemStack)Ic2Items.overClockerUpgrade, (int)2), Character.valueOf('D'), Ic2Items.diamondDrill, Character.valueOf('A'), "circuitAdvanced"});
        }
        if (Config.enableAdvancedChainsaw) {
            recipes.addRecipe(new ItemStack((Item)Registry.advancedChainsaw), new Object[]{" d ", "ODO", "AOA", Character.valueOf('d'), "gemDiamond", Character.valueOf('O'), StackUtil.copyWithSize((ItemStack)Ic2Items.overClockerUpgrade, (int)2), Character.valueOf('D'), Ic2Items.chainSaw, Character.valueOf('A'), "circuitAdvanced"});
        }
        if (Config.enableVajra && Config.enableAdvancedChainsaw && Config.enableAdvancedDrill && Config.enableMiscCraftingItems) {
            recipes.addRecipe(new ItemStack((Item)Registry.vajra), new Object[]{"IMI", "DVC", "ALA", Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('M'), Ic2Items.miningLaser, Character.valueOf('D'), Registry.advancedDiamondDrill, Character.valueOf('V'), Registry.vajraCore, Character.valueOf('C'), Registry.advancedChainsaw, Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('L'), Ic2Items.lapotronCrystal});
        }
    }

    public static boolean areOverrideRecipesValid() {
        return Config.enableIc2JetpackRecipOverrides && Config.enableCompactedElectricJetpackOverride && Config.enableCompactedNuclearJetpackOverride && Config.enableQuantumJetplateOverride && Config.enableQuantumNuclearJetplateOverride;
    }

    public static void initOverrideRecipes() {
        if (Config.enableAdvancedLappack) {
            recipes.overrideRecipe("shaped_item.itemarmorquantumpack_447958198", Ic2Items.quantumPack, new Object[]{" A ", "ILI", " l ", Character.valueOf('A'), "circuitAdvanced", Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('L'), Registry.getAdvancedLappack(), Character.valueOf('l'), Ic2Items.lapotronCrystal});
        }
        if (GravisuitRecipes.areOverrideRecipesValid()) {
            recipes.overrideRecipe("shaped_item.itemarmorcombinedjetpack_1604687096", Ic2Items.compactedElectricJetpack, new Object[]{" T ", "CBC", "JLJ", Character.valueOf('T'), Ic2Items.transformerUpgrade, Character.valueOf('C'), new RecipeInputOreDict("circuitAdvanced", 4), Character.valueOf('B'), Ic2Items.batPack, Character.valueOf('J'), Registry.getAdvancedElectricJetpack(), Character.valueOf('L'), Ic2Items.lapPack});
            recipes.overrideRecipe("shaped_item.itemarmornuclearcombindedjetpack_983003988", Ic2Items.compactedNuclearJetpack, new Object[]{" L ", "CNC", "BJB", Character.valueOf('L'), Ic2Items.lapPack, Character.valueOf('C'), new RecipeInputOreDict("circuitAdvanced", 4), Character.valueOf('N'), Registry.getAdvancedNuclearJetpack(), Character.valueOf('B'), Ic2Items.batPack, Character.valueOf('J'), Registry.getAdvancedElectricJetpack()});
            recipes.overrideRecipe("shaped_item.itemquantumarmorjetpack_320254911", Ic2Items.quantumJetplate, new Object[]{"ACA", "ILI", "IAI", Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('C'), Registry.advancedNanoChestplate, Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('L'), Ic2Items.lapotronCrystal});
            recipes.overrideRecipe("shaped_item.itemquantumarmornuclearjetplate_695318402", Ic2Items.quantumNuclearJetplate, new Object[]{"ACA", "ILI", "IAI", Character.valueOf('A'), Ic2Items.advancedAlloy, Character.valueOf('C'), Registry.advancedNuclearNanoChestplate, Character.valueOf('I'), Ic2Items.iridiumPlate, Character.valueOf('L'), Ic2Items.lapotronCrystal});
            recipes.addRecipe(Ic2Items.quantumJetplate, new Object[]{"ICI", "cQc", "GLG", Character.valueOf('I'), StackUtil.copyWithSize((ItemStack)Ic2Items.iridiumPlate, (int)2), Character.valueOf('C'), Ic2Items.compactedElectricJetpack, Character.valueOf('c'), "circuitAdvanced", Character.valueOf('Q'), Ic2Items.quantumChest, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('L'), Ic2Items.lapotronCrystal});
            recipes.addRecipe(Ic2Items.quantumNuclearJetplate, new Object[]{"ICI", "cQc", "GLG", Character.valueOf('I'), StackUtil.copyWithSize((ItemStack)Ic2Items.iridiumPlate, (int)2), Character.valueOf('C'), Ic2Items.compactedNuclearJetpack, Character.valueOf('c'), "circuitAdvanced", Character.valueOf('Q'), Ic2Items.quantumChest, Character.valueOf('G'), Ic2Items.glassFiberCable, Character.valueOf('L'), Ic2Items.lapotronCrystal});
        }
    }
}

