/*
 * Decompiled with CFR 0.152.
 */
package nc.block;

import com.google.common.collect.Lists;
import java.util.List;
import nc.NuclearCraft;
import nc.block.tile.INBTDrop;
import nc.tile.ITile;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NCBlock
extends Block {
    protected final boolean canCreatureSpawn;
    protected static boolean keepInventory;

    public NCBlock(String name, Material material) {
        this(name, material, false);
    }

    public NCBlock(String name, Material material, boolean canCreatureSpawn) {
        super(material);
        this.func_149663_c("nuclearcraft." + name);
        if (NuclearCraft.regName) {
            this.setRegistryName(new ResourceLocation("nuclearcraft", name));
        }
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.canCreatureSpawn = canCreatureSpawn;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return this.canCreatureSpawn && super.canCreatureSpawn(state, world, pos, type);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this instanceof ITileEntityProvider && world.func_175625_s(pos) instanceof ITile) {
            ((ITile)world.func_175625_s(pos)).onBlockNeighborChanged(state, world, pos, fromPos);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this instanceof INBTDrop && willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this instanceof INBTDrop) {
            return Lists.newArrayList((Object[])new ItemStack[]{((INBTDrop)((Object)this)).getNBTDrop(world, pos, state)});
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        world.func_180501_a(pos, state, 2);
        if (this instanceof INBTDrop && stack.func_77942_o()) {
            ((INBTDrop)((Object)this)).readStackData(world, pos, player, stack);
        }
        world.func_184138_a(pos, state, state, 3);
    }

    public static class Transparent
    extends NCBlock {
        protected final boolean smartRender;

        public Transparent(String name, Material material, boolean smartRender) {
            super(name, material);
            this.func_149711_c(1.5f);
            this.func_149752_b(10.0f);
            this.smartRender = smartRender;
        }

        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }

        public boolean func_149686_d(IBlockState state) {
            return false;
        }

        public boolean func_149662_c(IBlockState state) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
            if (!this.smartRender) {
                return true;
            }
            IBlockState otherState = world.func_180495_p(pos.func_177972_a(side));
            Block block = otherState.func_177230_c();
            if (blockState != otherState) {
                return true;
            }
            return block == this ? false : super.func_176225_a(blockState, world, pos, side);
        }
    }
}

