/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.element;

import javax.annotation.Nonnull;
import nc.gui.element.GuiItemRenderer;
import nc.gui.element.NCGuiButton;
import nc.tile.ITile;
import nc.tile.fluid.ITileFluid;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class NCGuiToggleButton {

    @SideOnly(value=Side.CLIENT)
    public static class ToggleRedstoneControlButton
    extends ImageToggleButton {
        public ToggleRedstoneControlButton(int id, int x, int y, ITile machine) {
            super(id, x, y, 72, 0, 18, 18, machine.getRedstoneControl());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ToggleAlternateComparatorButton
    extends ImageToggleButton {
        public ToggleAlternateComparatorButton(int id, int x, int y, ITile machine) {
            super(id, x, y, 54, 0, 18, 18, machine.getAlternateComparator());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ToggleVoidExcessFluidOutputButton
    extends ImageToggleButton {
        public ToggleVoidExcessFluidOutputButton(int id, int x, int y, ITileFluid machine, int tankNumber) {
            super(id, x, y, 36, 0, 18, 18, machine.getVoidExcessFluidOutput(tankNumber));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ToggleVoidUnusableFluidInputButton
    extends ImageToggleButton {
        public ToggleVoidUnusableFluidInputButton(int id, int x, int y, ITileFluid machine, int tankNumber) {
            super(id, x, y, 18, 0, 18, 18, machine.getVoidUnusableFluidInput(tankNumber));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ToggleInputTanksSeparatedButton
    extends ImageToggleButton {
        public ToggleInputTanksSeparatedButton(int id, int x, int y, ITileFluid machine) {
            super(id, x, y, 0, 0, 18, 18, machine.getInputTanksSeparated());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemToggleButton
    extends ToggleButton {
        protected int field_146120_f;
        protected int field_146121_g;
        protected GuiItemRenderer unpressedItemRenderer;
        protected GuiItemRenderer pressedItemRenderer;

        public ItemToggleButton(int id, int x, int y, int width, int height, float unpressedAlph, @Nonnull Item unpressedItem, int unpressedItemMeta, float pressedAlph, @Nonnull Item pressedItem, int pressedItemMeta, boolean pressed) {
            super(id, x, y, width, height, "", "", pressed);
            this.field_146120_f = width;
            this.field_146121_g = height;
            this.unpressedItemRenderer = new GuiItemRenderer(x + (width - 16) / 2, y + (height - 16) / 2, unpressedAlph, unpressedItem, unpressedItemMeta);
            this.pressedItemRenderer = new GuiItemRenderer(x + (width - 16) / 2, y + (height - 16) / 2, pressedAlph, pressedItem, pressedItemMeta);
        }

        public GuiItemRenderer getItemRenderer() {
            if (this.isButtonPressed) {
                return this.pressedItemRenderer;
            }
            return this.unpressedItemRenderer;
        }

        public void func_191745_a(Minecraft minecraft, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                this.getItemRenderer().draw();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ImageToggleButton
    extends ToggleButton {
        public final ResourceLocation unpressedTexture = new ResourceLocation("nuclearcraft:textures/gui/buttons/off.png");
        public final ResourceLocation pressedTexture = new ResourceLocation("nuclearcraft:textures/gui/buttons/on.png");
        protected int textureX;
        protected int textureY;
        protected int textureWidth;
        protected int textureHeight;

        public ImageToggleButton(int id, int x, int y, int textureX, int textureY, int textureWidth, int textureHeight, boolean pressed) {
            super(id, x, y, textureWidth, textureHeight, "", "", pressed);
            this.textureX = textureX;
            this.textureY = textureY;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }

        public ResourceLocation getTexture() {
            if (this.isButtonPressed) {
                return this.pressedTexture;
            }
            return this.unpressedTexture;
        }

        public void func_191745_a(Minecraft minecraft, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                minecraft.func_110434_K().func_110577_a(this.getTexture());
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.textureX, this.textureY, this.textureWidth, this.textureHeight);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ToggleButton
    extends NCGuiButton.Button {
        public final String unpressedText;
        public final String pressedText;

        public ToggleButton(int id, int x, int y, int width, int height, String unpressedText, String pressedText, boolean pressed) {
            super(id, x, y, width, height, unpressedText);
            this.unpressedText = unpressedText;
            this.pressedText = pressedText;
            this.isButtonPressed = pressed;
        }

        @Override
        public boolean func_146116_c(Minecraft minecraft, int mouseX, int mouseY) {
            boolean clicked;
            boolean bl = clicked = this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            if (clicked) {
                this.togglePressed();
            }
            return clicked;
        }

        @Override
        public void func_146118_a(int mouseX, int mouseY) {
        }

        public ToggleButton setPressed(boolean pressed) {
            this.isButtonPressed = pressed;
            this.field_146126_j = pressed ? this.pressedText : this.unpressedText;
            return this;
        }

        public boolean getPressed() {
            return this.isButtonPressed;
        }

        public boolean togglePressed() {
            this.setPressed(!this.isButtonPressed);
            return true;
        }
    }
}

