/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import nc.recipe.IRecipe;
import nc.recipe.IngredientSorption;
import nc.recipe.RecipeInfo;
import nc.recipe.RecipeMatchResult;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FluidRegHelper;
import nc.util.ItemStackHelper;
import nc.util.OreDictHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractRecipeHandler<T extends IRecipe> {
    private List<T> recipes = new ArrayList<T>();
    private static List<Class<?>> validItemInputs = Lists.newArrayList((Object[])new Class[]{IItemIngredient.class, ArrayList.class, String.class, Item.class, Block.class, ItemStack.class, ItemStack[].class});
    private static List<Class<?>> validFluidInputs = Lists.newArrayList((Object[])new Class[]{IFluidIngredient.class, ArrayList.class, String.class, Fluid.class, FluidStack.class, FluidStack[].class});
    private static List<Class<?>> validItemOutputs = Lists.newArrayList((Object[])new Class[]{IItemIngredient.class, String.class, Item.class, Block.class, ItemStack.class});
    private static List<Class<?>> validFluidOutputs = Lists.newArrayList((Object[])new Class[]{IFluidIngredient.class, String.class, Fluid.class, FluidStack.class});
    private static List<Class<?>> needItemAltering = Lists.newArrayList((Object[])new Class[]{Item.class, Block.class});
    private static List<Class<?>> needFluidAltering = Lists.newArrayList((Object[])new Class[]{Fluid.class});
    public static final List<Integer> INVALID = Lists.newArrayList((Object[])new Integer[]{-1});

    public abstract void addRecipes();

    public abstract String getRecipeName();

    public List<T> getRecipes() {
        return this.recipes;
    }

    public abstract void addRecipe(Object ... var1);

    @Nullable
    public RecipeInfo<T> getRecipeInfoFromInputs(List<ItemStack> itemInputs, List<Tank> fluidInputs) {
        if (AbstractRecipeHandler.isFullNull(itemInputs, fluidInputs)) {
            return null;
        }
        for (IRecipe recipe : this.recipes) {
            RecipeMatchResult matchResult = recipe.matchInputs(itemInputs, fluidInputs);
            if (!matchResult.matches()) continue;
            return new RecipeInfo<IRecipe>(recipe, matchResult);
        }
        return null;
    }

    @Nullable
    public RecipeInfo<T> getRecipeInfoFromOutputs(List<ItemStack> itemOutputs, List<Tank> fluidOutputs) {
        if (AbstractRecipeHandler.isFullNull(itemOutputs, fluidOutputs)) {
            return null;
        }
        for (IRecipe recipe : this.recipes) {
            RecipeMatchResult matchResult = recipe.matchOutputs(itemOutputs, fluidOutputs);
            if (!matchResult.matches()) continue;
            return new RecipeInfo<IRecipe>(recipe, matchResult);
        }
        return null;
    }

    private static boolean isFullNull(List<ItemStack> items, List<Tank> tanks) {
        for (ItemStack item : items) {
            if (item == null || item.func_190926_b()) continue;
            return false;
        }
        for (Tank tank : tanks) {
            if (tank.getFluid() == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public T getRecipeFromIngredients(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchIngredients(itemIngredients, fluidIngredients).matches()) continue;
            return (T)recipe;
        }
        return null;
    }

    @Nullable
    public T getRecipeFromProducts(List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts) {
        for (IRecipe recipe : this.recipes) {
            if (!recipe.matchProducts(itemProducts, fluidProducts).matches()) continue;
            return (T)recipe;
        }
        return null;
    }

    public boolean addRecipe(T recipe) {
        return recipe != null ? this.recipes.add(recipe) : false;
    }

    public boolean removeRecipe(T recipe) {
        return recipe != null ? this.recipes.remove(recipe) : false;
    }

    public void removeAllRecipes() {
        this.recipes.clear();
    }

    public static void addValidItemInput(Class itemInputType) {
        validItemInputs.add(itemInputType);
    }

    public static void addValidFluidInput(Class fluidInputType) {
        validFluidInputs.add(fluidInputType);
    }

    public static void addValidItemOutput(Class itemOutputType) {
        validItemOutputs.add(itemOutputType);
    }

    public static void addValidFluidOutput(Class fluidOutputType) {
        validFluidOutputs.add(fluidOutputType);
    }

    public static boolean isValidItemInputType(Object itemInput) {
        for (Class<?> itemInputType : validItemInputs) {
            if (itemInput instanceof ArrayList && itemInputType == ArrayList.class) {
                ArrayList list = (ArrayList)itemInput;
                for (Object obj : list) {
                    if (!AbstractRecipeHandler.isValidItemInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!itemInputType.isInstance(itemInput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFluidInputType(Object fluidInput) {
        for (Class<?> fluidInputType : validFluidInputs) {
            if (fluidInput instanceof ArrayList && fluidInputType == ArrayList.class) {
                ArrayList list = (ArrayList)fluidInput;
                for (Object obj : list) {
                    if (!AbstractRecipeHandler.isValidFluidInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!fluidInputType.isInstance(fluidInput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidItemOutputType(Object itemOutput) {
        for (Class<?> itemOutputType : validItemOutputs) {
            if (!itemOutputType.isInstance(itemOutput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFluidOutputType(Object fluidOutput) {
        for (Class<?> fluidOutputType : validFluidOutputs) {
            if (!fluidOutputType.isInstance(fluidOutput)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresItemFixing(Object object) {
        for (Class<?> objectType : needItemAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresFluidFixing(Object object) {
        for (Class<?> objectType : needFluidAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidItemInput(ItemStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IItemIngredient input : recipe.itemIngredients()) {
                if (!input.match(stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidFluidInput(FluidStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IFluidIngredient input : recipe.fluidIngredients()) {
                if (!input.match(stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidItemOutput(ItemStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IItemIngredient output : recipe.itemProducts()) {
                if (!output.match(stack, IngredientSorption.OUTPUT).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidFluidOutput(FluidStack stack) {
        for (IRecipe recipe : this.recipes) {
            for (IFluidIngredient output : recipe.fluidProducts()) {
                if (!output.match(stack, IngredientSorption.OUTPUT).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidItemInput(ItemStack stack, ItemStack slotStack, List<ItemStack> otherInputs) {
        if (otherInputs.isEmpty() || stack.func_77969_a(slotStack) && ItemStackHelper.areItemStackTagsEqual(stack, slotStack)) {
            return this.isValidItemInput(stack);
        }
        ArrayList<ItemStack> otherStacks = new ArrayList<ItemStack>();
        for (ItemStack otherInput : otherInputs) {
            if (otherInput.func_190926_b()) continue;
            otherStacks.add(otherInput);
        }
        if (otherStacks.isEmpty()) {
            return this.isValidItemInput(stack);
        }
        ArrayList allStacks = Lists.newArrayList((Object[])new ItemStack[]{stack});
        allStacks.addAll(otherStacks);
        ArrayList<T> recipeList = new ArrayList<T>(this.recipes);
        block1: for (IRecipe recipe : this.recipes) {
            block2: for (ItemStack obj : allStacks) {
                for (IItemIngredient input : recipe.itemIngredients()) {
                    if (!input.match(obj, IngredientSorption.NEUTRAL).matches()) continue;
                    continue block2;
                }
                recipeList.remove(recipe);
                continue block1;
            }
        }
        for (IRecipe recipe : recipeList) {
            for (IItemIngredient input : recipe.itemIngredients()) {
                if (!input.match(stack, IngredientSorption.NEUTRAL).matches()) continue;
                for (ItemStack other : otherStacks) {
                    if (!input.match(other, IngredientSorption.NEUTRAL).matches()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static OreIngredient oreStack(String oreType, int stackSize) {
        if (!OreDictHelper.oreExists(oreType)) {
            return null;
        }
        return new OreIngredient(oreType, stackSize);
    }

    public static FluidIngredient fluidStack(String fluidName, int stackSize) {
        if (!FluidRegHelper.fluidExists(fluidName)) {
            return null;
        }
        return new FluidIngredient(fluidName, stackSize);
    }

    public static List<OreIngredient> oreStackList(List<String> oreTypes, int stackSize) {
        ArrayList<OreIngredient> oreStackList = new ArrayList<OreIngredient>();
        for (String oreType : oreTypes) {
            if (AbstractRecipeHandler.oreStack(oreType, stackSize) == null) continue;
            oreStackList.add(AbstractRecipeHandler.oreStack(oreType, stackSize));
        }
        return oreStackList;
    }

    public static List<FluidIngredient> fluidStackList(List<String> fluidNames, int stackSize) {
        ArrayList<FluidIngredient> fluidStackList = new ArrayList<FluidIngredient>();
        for (String fluidName : fluidNames) {
            if (AbstractRecipeHandler.fluidStack(fluidName, stackSize) == null) continue;
            fluidStackList.add(AbstractRecipeHandler.fluidStack(fluidName, stackSize));
        }
        return fluidStackList;
    }

    public static EmptyItemIngredient emptyItemStack() {
        return new EmptyItemIngredient();
    }

    public static EmptyFluidIngredient emptyFluidStack() {
        return new EmptyFluidIngredient();
    }

    public static ChanceItemIngredient chanceItemStack(ItemStack stack, int chancePercent) {
        if (stack == null) {
            return null;
        }
        return new ChanceItemIngredient(new ItemIngredient(stack), chancePercent);
    }

    public static ChanceItemIngredient chanceItemStack(ItemStack stack, int chancePercent, int minStackSize) {
        if (stack == null) {
            return null;
        }
        return new ChanceItemIngredient(new ItemIngredient(stack), chancePercent, minStackSize);
    }

    public static ChanceItemIngredient chanceOreStack(String oreType, int stackSize, int chancePercent) {
        if (!OreDictHelper.oreExists(oreType)) {
            return null;
        }
        return new ChanceItemIngredient(AbstractRecipeHandler.oreStack(oreType, stackSize), chancePercent);
    }

    public static ChanceItemIngredient chanceOreStack(String oreType, int stackSize, int chancePercent, int minStackSize) {
        if (!OreDictHelper.oreExists(oreType)) {
            return null;
        }
        return new ChanceItemIngredient(AbstractRecipeHandler.oreStack(oreType, stackSize), chancePercent, minStackSize);
    }

    public static ChanceFluidIngredient chanceFluidStack(String fluidName, int stackSize, int chancePercent, int stackDiff) {
        if (!FluidRegHelper.fluidExists(fluidName)) {
            return null;
        }
        return new ChanceFluidIngredient(AbstractRecipeHandler.fluidStack(fluidName, stackSize), chancePercent, stackDiff);
    }

    public static ChanceFluidIngredient chanceFluidStack(String fluidName, int stackSize, int chancePercent, int stackDiff, int minStackSize) {
        if (!FluidRegHelper.fluidExists(fluidName)) {
            return null;
        }
        return new ChanceFluidIngredient(AbstractRecipeHandler.fluidStack(fluidName, stackSize), chancePercent, stackDiff, minStackSize);
    }

    public static List<ChanceItemIngredient> chanceOreStackList(List<String> oreTypes, int stackSize, int chancePercent) {
        ArrayList<ChanceItemIngredient> oreStackList = new ArrayList<ChanceItemIngredient>();
        for (String oreType : oreTypes) {
            if (AbstractRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent) == null) continue;
            oreStackList.add(AbstractRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent));
        }
        return oreStackList;
    }

    public static List<ChanceItemIngredient> chanceOreStackList(List<String> oreTypes, int stackSize, int chancePercent, int minStackSize) {
        ArrayList<ChanceItemIngredient> oreStackList = new ArrayList<ChanceItemIngredient>();
        for (String oreType : oreTypes) {
            if (AbstractRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent, minStackSize) == null) continue;
            oreStackList.add(AbstractRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent, minStackSize));
        }
        return oreStackList;
    }

    public static List<ChanceFluidIngredient> chanceFluidStackList(List<String> fluidNames, int stackSize, int chancePercent, int stackDiff) {
        ArrayList<ChanceFluidIngredient> fluidStackList = new ArrayList<ChanceFluidIngredient>();
        for (String fluidName : fluidNames) {
            if (AbstractRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff) == null) continue;
            fluidStackList.add(AbstractRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff));
        }
        return fluidStackList;
    }

    public static List<ChanceFluidIngredient> chanceFluidStackList(List<String> fluidNames, int stackSize, int chancePercent, int stackDiff, int minStackSize) {
        ArrayList<ChanceFluidIngredient> fluidStackList = new ArrayList<ChanceFluidIngredient>();
        for (String fluidName : fluidNames) {
            if (AbstractRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff, minStackSize) == null) continue;
            fluidStackList.add(AbstractRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff, minStackSize));
        }
        return fluidStackList;
    }
}

