/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.api.client.shader;

import java.nio.FloatBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class Light {
    public static final float DOT_15 = 0.966f;
    public static final float DOT_30 = 0.866f;
    public static final float DOT_45 = 0.707f;
    public static final float DOT_60 = 0.5f;
    public static final float DOT_90 = 0.0f;
    public float x;
    public float y;
    public float z;
    public float r;
    public float g;
    public float b;
    public float a;
    public float l;
    public float mag = 1.0f;
    public float sx;
    public float sy;
    public float sz;
    public float sf;
    public Entity entity;

    protected Light(float x, float y, float z, float r, float g, float b, float a, float radius) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.l = 1.0f;
        this.sx = radius;
        this.sy = 0.0f;
        this.sz = 0.0f;
    }

    public void writeTo(float[] buf, int ofs) {
        buf[ofs + 0] = this.r;
        buf[ofs + 1] = this.g;
        buf[ofs + 2] = this.b;
        buf[ofs + 3] = this.a;
        buf[ofs + 4] = this.x;
        buf[ofs + 5] = this.y;
        buf[ofs + 6] = this.z;
        buf[ofs + 7] = this.sx;
        buf[ofs + 8] = this.sy;
        buf[ofs + 9] = this.sz;
        buf[ofs + 10] = this.l;
    }

    public void writeTo(FloatBuffer buf) {
        buf.put(this.r);
        buf.put(this.g);
        buf.put(this.b);
        buf.put(this.a);
        buf.put(this.x);
        buf.put(this.y);
        buf.put(this.z);
        buf.put(this.sx);
        buf.put(this.sy);
        buf.put(this.sz);
        buf.put(this.l);
    }

    public void moveTo(BlockPos pos) {
        this.x = (float)pos.func_177958_n() + 0.5f;
        this.y = (float)pos.func_177956_o() + 0.5f;
        this.z = (float)pos.func_177952_p() + 0.5f;
    }

    public void moveTo(Entity entity) {
        this.x = (float)entity.field_70165_t;
        this.y = (float)entity.field_70163_u + entity.func_70047_e();
        this.z = (float)entity.field_70161_v;
    }

    public void moveAndOrientTo(Entity entity) {
        this.moveTo(entity);
        Vec3d vec = entity.func_70040_Z();
        this.sx = (float)vec.field_72450_a * this.mag;
        this.sy = (float)vec.field_72448_b * this.mag;
        this.sz = (float)vec.field_72449_c * this.mag;
    }

    public Light setEntity(Entity entity) {
        this.entity = entity;
        return this;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float x = 0.0f;
        private float y = 0.0f;
        private float z = 0.0f;
        private float r = 1.0f;
        private float g = 1.0f;
        private float b = 1.0f;
        private float a = 1.0f;
        private float l = 1.0f;
        private float radius = Float.NaN;
        private final float sx = 1.0f;
        private final float sy = 0.0f;
        private final float sz = 0.0f;
        private Entity entity;

        public Builder pos(BlockPos pos) {
            return this.pos((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        }

        public Builder pos(Vec3d pos) {
            return this.pos(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }

        public Builder pos(Entity e) {
            this.entity = e;
            return this.pos(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        }

        public Builder pos(double x, double y, double z) {
            return this.pos((float)x, (float)y, (float)z);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder color(int c, boolean hasAlpha) {
            return this.color(this.extract(c, 2), this.extract(c, 1), this.extract(c, 0), hasAlpha ? this.extract(c, 3) : 1.0f);
        }

        private float extract(int i, int idx) {
            return (float)(i >> idx * 8 & 0xFF) / 255.0f;
        }

        public Builder color(float r, float g, float b) {
            return this.color(r, g, b, 1.0f);
        }

        public Builder color(float r, float g, float b, float a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
            return this;
        }

        public Builder radius(float radius) {
            this.radius = radius;
            return this;
        }

        public Builder intensity(float l) {
            this.l = l;
            return this;
        }

        public Light build() {
            if (Float.isFinite(this.radius)) {
                Light l = new Light(this.x, this.y, this.z, this.r, this.g, this.b, this.a, 1.0f);
                l.sx = 1.0f * this.radius;
                l.sy = 0.0f * this.radius;
                l.sz = 0.0f * this.radius;
                l.mag = this.radius;
                l.l = this.l;
                if (this.entity != null) {
                    l.setEntity(this.entity);
                }
                return l;
            }
            throw new IllegalArgumentException("Radius must be set, and cannot be infinite");
        }
    }
}

