/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.world.gen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.ChunkProviderBase;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Billowed;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlock;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.SpecialAsteroidBlockHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.MapGenAbandonedBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenTrees;

public class ChunkProviderAsteroids
extends ChunkProviderBase {
    final Block ASTEROID_STONE = AsteroidBlocks.blockBasic;
    final byte ASTEROID_STONE_META_0 = 0;
    final byte ASTEROID_STONE_META_1 = 1;
    final byte ASTEROID_STONE_META_2 = (byte)2;
    final Block DIRT = Blocks.field_150346_d;
    final byte DIRT_META = 0;
    final Block GRASS = Blocks.field_150349_c;
    final byte GRASS_META = 0;
    final Block LIGHT = Blocks.field_150426_aN;
    final byte LIGHT_META = 0;
    BlockTallGrass.EnumType GRASS_TYPE = BlockTallGrass.EnumType.GRASS;
    final BlockFlower FLOWER = Blocks.field_150328_O;
    final Block LAVA = Blocks.field_150353_l;
    final byte LAVA_META = 0;
    final Block WATER = Blocks.field_150355_j;
    final byte WATER_META = 0;
    private final Random rand;
    private final World world;
    private final NoiseModule asteroidDensity;
    private final NoiseModule asteroidTurbulance;
    private final NoiseModule asteroidSkewX;
    private final NoiseModule asteroidSkewY;
    private final NoiseModule asteroidSkewZ;
    private final SpecialAsteroidBlockHandler coreHandler;
    private final SpecialAsteroidBlockHandler shellHandler;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_SIZE_Z = 16;
    private static final int MAX_ASTEROID_RADIUS = 25;
    private static final int MIN_ASTEROID_RADIUS = 5;
    private static final int MAX_ASTEROID_SKEW = 8;
    private static final int MIN_ASTEROID_Y = 48;
    private static final int MAX_ASTEROID_Y = 208;
    private static final int ASTEROID_CHANCE = 800;
    private static final int ASTEROID_CORE_CHANCE = 2;
    private static final int ASTEROID_SHELL_CHANCE = 2;
    private static final int MIN_BLOCKS_PER_CHUNK = 50;
    private static final int MAX_BLOCKS_PER_CHUNK = 200;
    private static final int ILMENITE_CHANCE = 400;
    private static final int IRON_CHANCE = 300;
    private static final int ALUMINUM_CHANCE = 250;
    private static final int RANDOM_BLOCK_FADE_SIZE = 32;
    private static final int FADE_BLOCK_CHANCE = 5;
    private static final int NOISE_OFFSET_SIZE = 256;
    private static final float MIN_HOLLOW_SIZE = 0.6f;
    private static final float MAX_HOLLOW_SIZE = 0.8f;
    private static final int HOLLOW_CHANCE = 10;
    private static final int MIN_RADIUS_FOR_HOLLOW = 15;
    private static final float HOLLOW_LAVA_SIZE = 0.12f;
    private static final int TREE_CHANCE = 2;
    private static final int TALL_GRASS_CHANCE = 2;
    private static final int FLOWER_CHANCE = 2;
    private static final int WATER_CHANCE = 2;
    private static final int LAVA_CHANCE = 2;
    private static final int GLOWSTONE_CHANCE = 20;
    private LinkedList<AsteroidData> largeAsteroids = new LinkedList();
    private int largeCount = 0;
    private static HashSet<BlockVec3> chunksDone = new HashSet();
    private int largeAsteroidsLastChunkX;
    private int largeAsteroidsLastChunkZ;
    private final MapGenAbandonedBase dungeonGenerator = new MapGenAbandonedBase();

    public ChunkProviderAsteroids(World par1World, long par2, boolean par4) {
        this.world = par1World;
        this.rand = new Random(par2);
        this.asteroidDensity = new Billowed(this.rand.nextLong(), 2, 0.25f);
        this.asteroidDensity.setFrequency(0.009f);
        this.asteroidDensity.amplitude = 0.6f;
        this.asteroidTurbulance = new Gradient(this.rand.nextLong(), 1, 0.2f);
        this.asteroidTurbulance.setFrequency(0.08f);
        this.asteroidTurbulance.amplitude = 0.5f;
        this.asteroidSkewX = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewX.amplitude = 8.0f;
        this.asteroidSkewX.frequencyX = 0.005f;
        this.asteroidSkewY = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewY.amplitude = 8.0f;
        this.asteroidSkewY.frequencyY = 0.005f;
        this.asteroidSkewZ = new Gradient(this.rand.nextLong(), 1, 1.0f);
        this.asteroidSkewZ.amplitude = 8.0f;
        this.asteroidSkewZ.frequencyZ = 0.005f;
        this.coreHandler = new SpecialAsteroidBlockHandler();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 5, 0.3));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_1, 7, 0.3));
        ((Object)((Object)this)).getClass();
        this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 11, 0.25));
        if (!ConfigManagerAsteroids.disableAluminumGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 3, 5, 0.2));
        }
        if (!ConfigManagerAsteroids.disableIlmeniteGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 4, 4, 0.15));
        }
        if (!ConfigManagerAsteroids.disableIronGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 5, 3, 0.2));
        }
        if (ConfigManagerCore.enableSiliconOreGen) {
            this.coreHandler.addBlock(new SpecialAsteroidBlock(GCBlocks.basicBlock, 8, 2, 0.15));
        }
        this.coreHandler.addBlock(new SpecialAsteroidBlock(GCBlocks.basicBlock, 12, 2, 0.13));
        this.coreHandler.addBlock(new SpecialAsteroidBlock(Blocks.field_150482_ag, 0, 1, 0.1));
        this.shellHandler = new SpecialAsteroidBlockHandler();
        ((Object)((Object)this)).getClass();
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, 0, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_1, 3, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(this.ASTEROID_STONE, this.ASTEROID_STONE_META_2, 1, 0.15));
        this.shellHandler.addBlock(new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15));
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer primer, boolean flagDataOnly) {
        this.largeAsteroids.clear();
        this.largeCount = 0;
        Random random = new Random();
        int asteroidChance = 800;
        int rangeY = 160;
        int rangeSize = 20;
        for (int i = chunkX - 3; i < chunkX + 3; ++i) {
            int minX = i * 16;
            int maxX = minX + 16;
            for (int k = chunkZ - 3; k < chunkZ + 3; ++k) {
                int minZ = k * 16;
                int maxZ = minZ + 16;
                for (int x = minX; x < maxX; x += 2) {
                    for (int z = minZ; z < maxZ; z += 2) {
                        if (!((double)this.randFromPointPos(x, z) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                        random.setSeed(x + z * 3067);
                        int y = random.nextInt(160) + 48;
                        int size = random.nextInt(20) + 5;
                        this.generateAsteroid(random, x, y, z, chunkX << 4, chunkZ << 4, size, primer, flagDataOnly);
                        ++this.largeCount;
                    }
                }
            }
        }
    }

    private void generateAsteroid(Random rand, int asteroidX, int asteroidY, int asteroidZ, int chunkX, int chunkZ, int size, ChunkPrimer primer, boolean flagDataOnly) {
        int distanceX;
        int indexXZ;
        int indexXY;
        int x;
        SpecialAsteroidBlock core = this.coreHandler.getBlock(rand, size);
        SpecialAsteroidBlock shell = null;
        if (rand.nextInt(2) == 0) {
            shell = this.shellHandler.getBlock(rand, size);
        }
        boolean isHollow = false;
        float hollowSize = rand.nextFloat() * 0.19999999f + 0.6f;
        if (rand.nextInt(10) == 0 && size >= 15) {
            isHollow = true;
            shell = new SpecialAsteroidBlock(AsteroidBlocks.blockDenseIce, 0, 1, 0.15);
        }
        ((WorldProviderAsteroids)this.world.field_73011_w).addAsteroid(asteroidX, asteroidY, asteroidZ, size, isHollow ? -1 : core.index);
        int xMin = this.clamp(Math.max(chunkX, asteroidX - size - 8 - 2) - chunkX, 0, 16);
        int zMin = this.clamp(Math.max(chunkZ, asteroidZ - size - 8 - 2) - chunkZ, 0, 16);
        int yMin = asteroidY - size - 8 - 2;
        int yMax = asteroidY + size + 8 + 2;
        int xMax = this.clamp(Math.min(chunkX + 16, asteroidX + size + 8 + 2) - chunkX, 0, 16);
        int zMax = this.clamp(Math.min(chunkZ + 16, asteroidZ + size + 8 + 2) - chunkZ, 0, 16);
        int xSize = xMax - xMin;
        int ySize = yMax - yMin;
        int zSize = zMax - zMin;
        if (xSize <= 0 || ySize <= 0 || zSize <= 0) {
            return;
        }
        float noiseOffsetX = this.randFromPoint(asteroidX, asteroidY, asteroidZ) * 256.0f + (float)chunkX;
        float noiseOffsetY = this.randFromPoint(asteroidX * 7, asteroidY * 11, asteroidZ * 13) * 256.0f;
        float noiseOffsetZ = this.randFromPoint(asteroidX * 17, asteroidY * 23, asteroidZ * 29) * 256.0f + (float)chunkZ;
        this.setOtherAxisFrequency(1.0f / ((float)size * 2.0f / 2.0f));
        float[] sizeXArray = new float[ySize * zSize];
        float[] sizeZArray = new float[xSize * ySize];
        float[] sizeYArray = new float[xSize * zSize];
        for (int x2 = 0; x2 < xSize; ++x2) {
            int xx = x2 * zSize;
            float xxx = (float)x2 + noiseOffsetX;
            for (int z = 0; z < zSize; ++z) {
                sizeYArray[xx + z] = this.asteroidSkewY.getNoise(xxx, (float)z + noiseOffsetZ);
            }
        }
        AsteroidData asteroidData = new AsteroidData(isHollow, sizeYArray, xMin, zMin, xMax, zMax, zSize, size, asteroidX, asteroidY, asteroidZ);
        this.largeAsteroids.add(asteroidData);
        this.largeAsteroidsLastChunkX = chunkX;
        this.largeAsteroidsLastChunkZ = chunkZ;
        if (flagDataOnly) {
            return;
        }
        for (int y = 0; y < ySize; ++y) {
            int yy = y * zSize;
            float yyy = (float)y + noiseOffsetY;
            for (int z = 0; z < zSize; ++z) {
                sizeXArray[yy + z] = this.asteroidSkewX.getNoise(yyy, (float)z + noiseOffsetZ);
            }
        }
        for (int x3 = 0; x3 < xSize; ++x3) {
            int xx = x3 * ySize;
            float xxx = (float)x3 + noiseOffsetX;
            for (int y = 0; y < ySize; ++y) {
                sizeZArray[xx + y] = this.asteroidSkewZ.getNoise(xxx, (float)y + noiseOffsetY);
            }
        }
        double shellThickness = 0.0;
        int terrainY = 0;
        int terrainYY = 0;
        IBlockState asteroidShell = null;
        if (shell != null) {
            asteroidShell = shell.block.func_176203_a((int)shell.meta);
            shellThickness = 1.0 - shell.thickness;
        }
        IBlockState asteroidCore = core.block.func_176203_a((int)core.meta);
        ((Object)((Object)this)).getClass();
        IBlockState asteroidRock0 = this.ASTEROID_STONE.func_176203_a(0);
        IBlockState asteroidRock1 = this.ASTEROID_STONE.func_176203_a(this.ASTEROID_STONE_META_1);
        IBlockState airBlock = Blocks.field_150350_a.func_176223_P();
        ((Object)((Object)this)).getClass();
        IBlockState dirtBlock = this.DIRT.func_176203_a(0);
        ((Object)((Object)this)).getClass();
        IBlockState grassBlock = this.GRASS.func_176203_a(0);
        for (x = xMax - 1; x >= xMin; --x) {
            indexXY = (x - xMin) * ySize - yMin;
            indexXZ = (x - xMin) * zSize - zMin;
            distanceX = asteroidX - (x + chunkX);
            int indexBaseX = x * 256 << 4;
            float xx = x + chunkX;
            for (int z = zMin; z < zMax; ++z) {
                if (isHollow) {
                    float sizeModY = sizeYArray[indexXZ + z];
                    terrainY = this.getTerrainHeightFor(sizeModY, asteroidY, size);
                    terrainYY = this.getTerrainHeightFor(sizeModY, asteroidY - 1, size);
                }
                float sizeY = (float)size + sizeYArray[indexXZ + z];
                sizeY *= sizeY;
                int distanceZ = asteroidZ - (z + chunkZ);
                int indexBase = indexBaseX | z * 256;
                float zz = z + chunkZ;
                for (int y = yMin; y < yMax; ++y) {
                    int index;
                    float distance;
                    float dSizeX = (float)distanceX / ((float)size + sizeXArray[(y - yMin) * zSize + z - zMin]);
                    float dSizeZ = (float)distanceZ / ((float)size + sizeZArray[indexXY + y]);
                    dSizeX *= dSizeX;
                    dSizeZ *= dSizeZ;
                    int distanceY = asteroidY - y;
                    distanceY *= distanceY;
                    float distanceAbove = distance = dSizeX + (float)distanceY / sizeY + dSizeZ;
                    distance += this.asteroidTurbulance.getNoise(xx, (float)y, zz);
                    if (isHollow && distance <= hollowSize && (distanceAbove += this.asteroidTurbulance.getNoise(xx, (float)(y + 1), zz)) <= 1.0f && y - 1 == terrainYY) {
                        index = indexBase | y + 1;
                        ((Object)((Object)this)).getClass();
                        primer.func_177855_a(x, y + 1, z, this.LIGHT.func_176203_a(0));
                    }
                    if (!(distance <= 1.0f)) continue;
                    index = indexBase | y;
                    if (isHollow && distance <= hollowSize) {
                        if (y == terrainY) {
                            primer.func_177855_a(x, y, z, grassBlock);
                            continue;
                        }
                        if (y < terrainY) {
                            primer.func_177855_a(x, y, z, dirtBlock);
                            continue;
                        }
                        primer.func_177855_a(x, y, z, airBlock);
                        continue;
                    }
                    if ((double)distance <= core.thickness) {
                        if (rand.nextBoolean()) {
                            primer.func_177855_a(x, y, z, asteroidCore);
                            continue;
                        }
                        primer.func_177855_a(x, y, z, asteroidRock0);
                        continue;
                    }
                    if (shell != null && (double)distance >= shellThickness) {
                        primer.func_177855_a(x, y, z, asteroidShell);
                        continue;
                    }
                    primer.func_177855_a(x, y, z, asteroidRock1);
                }
            }
        }
        if (isHollow) {
            shellThickness = 0.0;
            if (shell != null) {
                shellThickness = 1.0 - shell.thickness;
            }
            for (x = xMin; x < xMax; ++x) {
                indexXY = (x - xMin) * ySize - yMin;
                indexXZ = (x - xMin) * zSize - zMin;
                distanceX = asteroidX - (x + chunkX);
                distanceX *= distanceX;
                for (int z = zMin; z < zMax; ++z) {
                    float sizeModY = sizeYArray[indexXZ + z];
                    float sizeY = (float)size + sizeYArray[indexXZ + z];
                    sizeY *= sizeY;
                    int distanceZ = asteroidZ - (z + chunkZ);
                    distanceZ *= distanceZ;
                    for (int y = yMin; y < yMax; ++y) {
                        float sizeX = (float)size + sizeXArray[(y - yMin) * zSize + z - zMin];
                        float sizeZ = (float)size + sizeZArray[indexXY + y];
                        sizeX *= sizeX;
                        sizeZ *= sizeZ;
                        int distanceY = asteroidY - y;
                        distanceY *= distanceY;
                        float distance = (float)distanceX / sizeX + (float)distanceY / sizeY + (float)distanceZ / sizeZ;
                        if (!((distance += this.asteroidTurbulance.getNoise((float)(x + chunkX), (float)y, (float)(z + chunkZ))) <= 1.0f)) continue;
                        IBlockState state = primer.func_177856_a(x, y, z);
                        IBlockState stateAbove = primer.func_177856_a(x, y + 1, z);
                        if (Blocks.field_150350_a != stateAbove.func_177230_c() || state.func_177230_c() != this.ASTEROID_STONE && state.func_177230_c() != this.GRASS || this.rand.nextInt(20) != 0) continue;
                        ((Object)((Object)this)).getClass();
                        primer.func_177855_a(x, y, z, this.LIGHT.func_176203_a(0));
                    }
                }
            }
        }
    }

    private final void setOtherAxisFrequency(float frequency) {
        this.asteroidSkewX.frequencyY = frequency;
        this.asteroidSkewX.frequencyZ = frequency;
        this.asteroidSkewY.frequencyX = frequency;
        this.asteroidSkewY.frequencyZ = frequency;
        this.asteroidSkewZ.frequencyX = frequency;
        this.asteroidSkewZ.frequencyY = frequency;
    }

    private final int clamp(int x, int min, int max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final double clamp(double x, double min, double max) {
        if (x < min) {
            x = min;
        } else if (x > max) {
            x = max;
        }
        return x;
    }

    private final int getTerrainHeightFor(float yMod, int asteroidY, int asteroidSize) {
        return (int)((float)(asteroidY - asteroidSize / 4) + yMod * 1.5f);
    }

    private final int getTerrainHeightAt(int x, int z, float[] yModArray, int xMin, int zMin, int zSize, int asteroidY, int asteroidSize) {
        int index = (x - xMin) * zSize - zMin;
        if (index < yModArray.length && index >= 0) {
            float yMod = yModArray[index];
            return this.getTerrainHeightFor(yMod, asteroidY, asteroidSize);
        }
        return 1;
    }

    public Chunk func_185932_a(int par1, int par2) {
        ChunkPrimer primer = new ChunkPrimer();
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        this.generateTerrain(par1, par2, primer, false);
        if (this.world.field_73011_w instanceof WorldProviderAsteroids && ((WorldProviderAsteroids)this.world.field_73011_w).checkHasAsteroids()) {
            this.dungeonGenerator.func_186125_a(this.world, par1, par2, primer);
        }
        Chunk var4 = new Chunk(this.world, primer, par1, par2);
        byte[] biomesArray = var4.func_76605_m();
        byte b = (byte)Biome.func_185362_a((Biome)BiomeAdaptive.biomeDefault);
        for (int i = 0; i < biomesArray.length; ++i) {
            biomesArray[i] = b;
        }
        this.generateSkylightMap(var4, par1, par2);
        return var4;
    }

    private int getIndex(int x, int y, int z) {
        return x * 256 * 16 | z * 256 | y;
    }

    private String timeString(long time1, long time2) {
        int ms100 = (int)((time2 - time1) / 10000L);
        int msdecimal = ms100 % 100;
        String msd = (ms100 < 10 ? "0" : "") + ms100;
        return "" + ms100 / 100 + "." + msd + "ms";
    }

    private float randFromPoint(int x, int y, int z) {
        int n = x + z * 57 + y * 571;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPoint(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    private float randFromPointPos(int x, int z) {
        int n = x + z * 57;
        n ^= n << 13;
        n = n * (n * n * 15731 + 789221) + 1376312589 & 0x3FFFFFFF;
        return 1.0f - (float)n / 1.0737418E9f;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        long var9;
        long var7;
        int z;
        int x;
        block24: {
            x = chunkX << 4;
            z = chunkZ << 4;
            if (!chunksDone.add(new BlockVec3(x, 0, z))) {
                return;
            }
            this.rand.setSeed(this.world.func_72905_C());
            var7 = this.rand.nextLong() / 2L * 2L + 1L;
            var9 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.world.func_72905_C());
            if (!this.rand.nextBoolean()) break block24;
            double density = (double)this.asteroidDensity.getNoise((float)(chunkX * 16), (float)(chunkZ * 16)) * 0.54;
            double numOfBlocks = this.clamp(this.randFromPoint(chunkX, chunkZ), 0.4, 1.0) * 200.0 * density + 50.0;
            int y0 = this.rand.nextInt(2);
            int yRange = 160;
            x += 4;
            z += 4;
            int i = 0;
            while ((double)i < numOfBlocks) {
                block25: {
                    int meta;
                    Block block;
                    int pz;
                    int px;
                    int y;
                    block27: {
                        block28: {
                            block26: {
                                y = this.rand.nextInt(yRange) + 48;
                                if (y0 != y / 16 % 2) break block25;
                                px = x + this.rand.nextInt(16);
                                pz = z + this.rand.nextInt(16);
                                block = this.ASTEROID_STONE;
                                meta = this.ASTEROID_STONE_META_1;
                                if (this.rand.nextInt(400) != 0) break block26;
                                meta = 4;
                                if (!ConfigManagerAsteroids.disableIlmeniteGen) break block27;
                                break block25;
                            }
                            if (this.rand.nextInt(300) != 0) break block28;
                            meta = 5;
                            if (!ConfigManagerAsteroids.disableIronGen) break block27;
                            break block25;
                        }
                        if (this.rand.nextInt(250) != 0) break block27;
                        meta = 3;
                        if (ConfigManagerAsteroids.disableAluminumGen) break block25;
                    }
                    this.world.func_180501_a(new BlockPos(px, y, pz), block.func_176203_a(meta), 2);
                    int count = 9;
                    if (!(this.world.func_180495_p(new BlockPos(px - 1, y, pz)).func_177230_c() instanceof BlockAir)) {
                        count = 1;
                    } else if (!(this.world.func_180495_p(new BlockPos(px - 2, y, pz)).func_177230_c() instanceof BlockAir)) {
                        count = 3;
                    } else if (!(this.world.func_180495_p(new BlockPos(px - 3, y, pz)).func_177230_c() instanceof BlockAir)) {
                        count = 5;
                    } else if (!(this.world.func_180495_p(new BlockPos(px - 4, y, pz)).func_177230_c() instanceof BlockAir)) {
                        count = 7;
                    }
                }
                ++i;
            }
        }
        if (this.largeAsteroidsLastChunkX != chunkX || this.largeAsteroidsLastChunkZ != chunkZ) {
            this.generateTerrain(chunkX, chunkZ, null, true);
        }
        this.rand.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.world.func_72905_C());
        if (!this.largeAsteroids.isEmpty()) {
            for (AsteroidData asteroidIndex : new ArrayList<AsteroidData>(this.largeAsteroids)) {
                int i;
                if (!asteroidIndex.isHollow) continue;
                float[] sizeYArray = asteroidIndex.sizeYArray;
                int xMin = asteroidIndex.xMinArray;
                int zMin = asteroidIndex.zMinArray;
                int zSize = asteroidIndex.zSizeArray;
                int asteroidY = asteroidIndex.asteroidYArray;
                int asteroidSize = asteroidIndex.asteroidSizeArray;
                boolean treesdone = false;
                if (ConfigManagerCore.challengeAsteroidPopulation || this.rand.nextInt(2) == 0) {
                    int k;
                    int i2;
                    int treeType = this.rand.nextInt(3);
                    if (treeType == 1) {
                        treeType = 0;
                    }
                    IBlockState log = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
                    IBlockState leaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
                    WorldGenTrees wg = new WorldGenTrees(false, 2, log, leaves, false);
                    for (int tries = 0; tries < 5 && !wg.func_180709_b(this.world, this.rand, new BlockPos(i2 = this.rand.nextInt(16) + x + 8, this.getTerrainHeightAt(i2 - x, (k = this.rand.nextInt(16) + z + 8) - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k)); ++tries) {
                    }
                    treesdone = true;
                }
                if (!treesdone || this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    int k = this.rand.nextInt(16) + z + 8;
                    new WorldGenTallGrass(this.GRASS_TYPE).func_180709_b(this.world, this.rand, new BlockPos(i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k));
                }
                if (this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    int k = this.rand.nextInt(16) + z + 8;
                    int[] types = new int[]{2, 4, 5, 7};
                    new WorldGenFlowers(this.FLOWER, BlockFlower.EnumFlowerType.func_176967_a((BlockFlower.EnumFlowerColor)BlockFlower.EnumFlowerColor.RED, (int)types[this.rand.nextInt(types.length)])).func_180709_b(this.world, this.rand, new BlockPos(i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k));
                }
                if (this.rand.nextInt(2) == 0) {
                    i = this.rand.nextInt(16) + x + 8;
                    int k = this.rand.nextInt(16) + z + 8;
                    new WorldGenLakes(this.LAVA).func_180709_b(this.world, this.rand, new BlockPos(i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k));
                }
                if (this.rand.nextInt(2) != 0) continue;
                i = this.rand.nextInt(16) + x + 8;
                int k = this.rand.nextInt(16) + z + 8;
                new WorldGenLakes(this.WATER).func_180709_b(this.world, this.rand, new BlockPos(i, this.getTerrainHeightAt(i - x, k - z, sizeYArray, xMin, zMin, zSize, asteroidY, asteroidSize), k));
            }
        }
        for (int xx = 0; xx < 16; ++xx) {
            int xPos = x + xx;
            for (int zz = 0; zz < 16; ++zz) {
                int zPos = z + zz;
                for (int y = 16; y < 240; ++y) {
                }
            }
        }
        this.dungeonGenerator.func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
        this.dungeonGenerator.func_186125_a(this.world, x, z, null);
    }

    public void generateSkylightMap(Chunk chunk, int cx, int cz) {
        boolean flag = this.world.field_73011_w.func_191066_m();
        for (int j = 0; j < 16; ++j) {
            if (chunk.func_76587_i()[j] != null) continue;
            chunk.func_76587_i()[j] = new ExtendedBlockStorage(j << 4, flag);
        }
        int i = chunk.func_76625_h();
        chunk.field_82912_p = Integer.MAX_VALUE;
        for (int j = 0; j < 16; ++j) {
            block2: for (int k = 0; k < 16; ++k) {
                chunk.field_76638_b[j + (k << 4)] = -999;
                for (int y = i + 15; y > 0; --y) {
                    if (chunk.func_177437_b(new BlockPos(j, y - 1, k)) == 0) {
                        continue;
                    }
                    chunk.field_76634_f[k << 4 | j] = y;
                    if (y >= chunk.field_82912_p) continue block2;
                    chunk.field_82912_p = y;
                    continue block2;
                }
            }
        }
        for (AsteroidData a : this.largeAsteroids) {
            int yMin = a.asteroidYArray - a.asteroidSizeArray;
            int yMax = a.asteroidYArray + a.asteroidSizeArray;
            int xMin = a.xMinArray;
            if (yMin < 0) {
                yMin = 0;
            }
            if (yMax > 255) {
                yMax = 255;
            }
            if (xMin == 0) {
                xMin = 1;
            }
            for (int x = a.xMax - 1; x >= xMin; --x) {
                for (int z = a.zMinArray; z < a.zMax; ++z) {
                    for (int y = yMin; y < yMax; ++y) {
                        if (!(chunk.func_186032_a(x - 1, y, z).func_177230_c() instanceof BlockAir) || chunk.func_186032_a(x, y, z).func_177230_c() instanceof BlockAir) continue;
                        int count = 2;
                        if (x > 1 && chunk.func_186032_a(x - 2, y, z).func_177230_c() instanceof BlockAir) {
                            count += 2;
                        }
                        if (x > 2) {
                            if (chunk.func_186032_a(x - 3, y, z).func_177230_c() instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_186032_a(x - 3, y + 1, z).func_177230_c() instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_186032_a(x - 3, y + 1, z).func_177230_c() instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && chunk.func_186032_a(x - 3, y, z - 1).func_177230_c() instanceof BlockAir) {
                                ++count;
                            }
                            if (z < 15 && chunk.func_186032_a(x - 3, y, z + 1).func_177230_c() instanceof BlockAir) {
                                ++count;
                            }
                        }
                        if (x > 3) {
                            if (chunk.func_186032_a(x - 4, y, z).func_177230_c() instanceof BlockAir) {
                                count += 2;
                            }
                            if (chunk.func_186032_a(x - 4, y + 1, z).func_177230_c() instanceof BlockAir) {
                                ++count;
                            }
                            if (chunk.func_186032_a(x - 4, y + 1, z).func_177230_c() instanceof BlockAir) {
                                ++count;
                            }
                            if (z > 0 && !(chunk.func_186032_a(x - 4, y, z - 1).func_177230_c() instanceof BlockAir)) {
                                ++count;
                            }
                            if (z < 15 && !(chunk.func_186032_a(x - 4, y, z + 1).func_177230_c() instanceof BlockAir)) {
                                ++count;
                            }
                        }
                        if (count > 12) {
                            count = 12;
                        }
                        if (count > 12) {
                            count = 12;
                        }
                        chunk.func_177436_a(new BlockPos(x - 1, y, z), GCBlocks.brightAir.func_176203_a(13 - count));
                        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[y >> 4];
                        if (extendedblockstorage == null) continue;
                        extendedblockstorage.func_76677_d(x - 1, y & 0xF, z, count + 2);
                    }
                }
            }
        }
        chunk.func_177427_f(true);
    }

    public void resetBase() {
        this.dungeonGenerator.reset();
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    public BlockVec3 isLargeAsteroidAt(int x0, int z0) {
        for (int i0 = 0; i0 <= 32; ++i0) {
            for (int i1 = -i0; i1 <= i0; ++i1) {
                int xToCheck = (x0 >> 4) + i0;
                int zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) + i0;
                zToCheck = (z0 >> 4) - i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) + i1;
                if (this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) {
                    return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
                }
                xToCheck = (x0 >> 4) - i0;
                zToCheck = (z0 >> 4) - i1;
                if (!this.isLargeAsteroidAt0(xToCheck * 16, zToCheck * 16)) continue;
                return new BlockVec3(xToCheck * 16, 0, zToCheck * 16);
            }
        }
        return null;
    }

    private boolean isLargeAsteroidAt0(int x0, int z0) {
        for (int x = x0; x < x0 + 16; x += 2) {
            for (int z = z0; z < z0 + 16; z += 2) {
                if (!((double)Math.abs(this.randFromPoint(x, z)) < ((double)this.asteroidDensity.getNoise((float)x, (float)z) + 0.4) / 800.0)) continue;
                return true;
            }
        }
        return false;
    }

    public static void reset() {
        chunksDone.clear();
    }

    private class AsteroidData {
        public boolean isHollow;
        public float[] sizeYArray;
        public int xMinArray;
        public int zMinArray;
        public int xMax;
        public int zMax;
        public int zSizeArray;
        public int asteroidSizeArray;
        public int asteroidXArray;
        public int asteroidYArray;
        public int asteroidZArray;

        public AsteroidData(boolean hollow, float[] sizeYArray2, int xMin, int zMin, int xmax, int zmax, int zSize, int size, int asteroidX, int asteroidY, int asteroidZ) {
            this.isHollow = hollow;
            this.sizeYArray = (float[])sizeYArray2.clone();
            this.xMinArray = xMin;
            this.zMinArray = zMin;
            this.xMax = xmax;
            this.zMax = zmax;
            this.zSizeArray = zSize;
            this.asteroidSizeArray = size;
            this.asteroidXArray = asteroidX;
            this.asteroidYArray = asteroidY;
            this.asteroidZArray = asteroidZ;
        }
    }
}

