/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.entities;

import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.sounds.GCSounds;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.mars.MarsModuleClient;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySludgeling;
import micdoodle8.mods.galacticraft.planets.mars.inventory.InventorySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntitySlimeling
extends EntityTameable
implements IEntityBreathable {
    public InventorySlimeling slimelingInventory = new InventorySlimeling(this);
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_RED = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_GREEN = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_BLUE = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> FAV_FOOD_ID = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ATTACK_DAMAGE = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> KILLS = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> OWNER_USERNAME = EntityDataManager.func_187226_a(EntitySlimeling.class, (DataSerializer)DataSerializers.field_187194_d);
    public float colorRed;
    public float colorGreen;
    public float colorBlue;
    public long ticksAlive;
    public int age = 0;
    public final int MAX_AGE = 100000;
    public String slimelingName = GCCoreUtil.translate((String)"gui.message.unnamed.name");
    public int favFoodID = 1;
    public float attackDamage = 0.05f;
    public int kills;

    public EntitySlimeling(World par1World) {
        super(par1World);
        this.func_70105_a(0.45f, 0.7f);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70911_d = new EntityAISitGC(this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntitySludgeling.class, false, p_apply_1_ -> p_apply_1_ instanceof EntitySludgeling));
        this.func_70903_f(false);
        switch (this.field_70146_Z.nextInt(3)) {
            case 0: {
                this.colorRed = 1.0f;
                break;
            }
            case 1: {
                this.colorBlue = 1.0f;
                break;
            }
            case 2: {
                this.colorRed = 1.0f;
                this.colorGreen = 1.0f;
            }
        }
        this.setRandomFavFood();
    }

    public EntityLivingBase func_70902_q() {
        String ownerName;
        EntityLivingBase owner = super.func_70902_q();
        if (owner == null && (ownerName = this.getOwnerUsername()) != null) {
            return this.field_70170_p.func_72924_a(ownerName);
        }
        return owner;
    }

    public boolean func_152114_e(EntityLivingBase entityLivingBase) {
        return entityLivingBase == this.func_70902_q();
    }

    public boolean func_70648_aU() {
        return true;
    }

    public float getSlimelingSize() {
        return this.getScale() * 2.0f;
    }

    public void func_98054_a(boolean par1) {
        this.func_98055_j(this.getSlimelingSize());
    }

    public boolean func_70631_g_() {
        float f = this.getAge();
        ((Object)((Object)this)).getClass();
        return f / 100000.0f < 0.33f;
    }

    private void setRandomFavFood() {
        switch (this.field_70146_Z.nextInt(10)) {
            case 0: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151043_k);
                break;
            }
            case 1: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151033_d);
                break;
            }
            case 2: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151168_bH);
                break;
            }
            case 3: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151052_q);
                break;
            }
            case 4: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151016_H);
                break;
            }
            case 5: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151017_I);
                break;
            }
            case 6: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151166_bC);
                break;
            }
            case 7: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151115_aP);
                break;
            }
            case 8: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151107_aW);
                break;
            }
            case 9: {
                this.favFoodID = Item.func_150891_b((Item)Items.field_151124_az);
            }
        }
    }

    public EntitySlimeling(World par1World, float red, float green, float blue) {
        this(par1World);
        this.colorRed = red;
        this.colorGreen = green;
        this.colorBlue = blue;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealthSlimeling());
    }

    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(COLOR_RED, (Object)Float.valueOf(this.colorRed));
        this.field_70180_af.func_187214_a(COLOR_GREEN, (Object)Float.valueOf(this.colorGreen));
        this.field_70180_af.func_187214_a(COLOR_BLUE, (Object)Float.valueOf(this.colorBlue));
        this.field_70180_af.func_187214_a(AGE, (Object)this.age);
        this.field_70180_af.func_187214_a(NAME, (Object)"");
        this.field_70180_af.func_187214_a(FAV_FOOD_ID, (Object)this.favFoodID);
        this.field_70180_af.func_187214_a(ATTACK_DAMAGE, (Object)Float.valueOf(this.attackDamage));
        this.field_70180_af.func_187214_a(KILLS, (Object)this.kills);
        this.field_70180_af.func_187214_a(OWNER_USERNAME, (Object)"");
        this.setName(GCCoreUtil.translate((String)"gui.message.unnamed.name"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74782_a("SlimelingInventory", (NBTBase)this.slimelingInventory.writeToNBT(new NBTTagList()));
        nbt.func_74776_a("SlimeRed", this.colorRed);
        nbt.func_74776_a("SlimeGreen", this.colorGreen);
        nbt.func_74776_a("SlimeBlue", this.colorBlue);
        nbt.func_74768_a("SlimelingAge", this.age);
        nbt.func_74778_a("SlimelingName", this.slimelingName);
        nbt.func_74768_a("FavFoodID", this.favFoodID);
        nbt.func_74776_a("SlimelingDamage", this.attackDamage);
        nbt.func_74768_a("SlimelingKills", this.kills);
        nbt.func_74778_a("OwnerUsername", this.getOwnerUsername());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.slimelingInventory.readFromNBT(nbt.func_150295_c("SlimelingInventory", 10));
        this.colorRed = nbt.func_74760_g("SlimeRed");
        this.colorGreen = nbt.func_74760_g("SlimeGreen");
        this.colorBlue = nbt.func_74760_g("SlimeBlue");
        this.age = nbt.func_74762_e("SlimelingAge");
        this.slimelingName = nbt.func_74779_i("SlimelingName");
        this.favFoodID = nbt.func_74762_e("FavFoodID");
        this.attackDamage = nbt.func_74760_g("SlimelingDamage");
        this.kills = nbt.func_74762_e("SlimelingKills");
        this.setOwnerUsername(nbt.func_74779_i("OwnerUsername"));
        this.setColorRed(this.colorRed);
        this.setColorGreen(this.colorGreen);
        this.setColorBlue(this.colorBlue);
        this.setAge(this.age);
        this.setName(this.slimelingName);
        this.setKillCount(this.kills);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a(SoundEvents.field_187888_ft, this.func_70599_aP(), 1.1f);
        return null;
    }

    protected SoundEvent func_184615_bR() {
        this.func_184185_a(GCSounds.slimeDeath, this.func_70599_aP(), 0.8f);
        return null;
    }

    protected Item func_146068_u() {
        return Items.field_151123_aH;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.ticksAlive <= 0L) {
                this.setColorRed(this.colorRed);
                this.setColorGreen(this.colorGreen);
                this.setColorBlue(this.colorBlue);
            }
            ++this.ticksAlive;
            if (this.ticksAlive % 2L == 0L) {
                if (this.age < this.MAX_AGE) {
                    ++this.age;
                }
                this.setAge(Math.min(this.age, this.MAX_AGE));
            }
            this.setFavoriteFood(this.favFoodID);
            this.setAttackDamage(this.attackDamage);
            this.setKillCount(this.kills);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase owner;
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealthSlimeling());
            if (this.getOwnerUsername().isEmpty() && (owner = this.func_70902_q()) != null) {
                this.setOwnerUsername(owner.func_70005_c_());
            }
        }
    }

    private double getMaxHealthSlimeling() {
        if (this.func_70909_n()) {
            return 20.001 + 30.0 * ((double)this.age / (double)this.MAX_AGE);
        }
        return 8.0;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (this.func_180431_b(par1DamageSource)) {
            return false;
        }
        Entity entity = par1DamageSource.func_76346_g();
        this.setSittingAI(false);
        if (entity != null && !(entity instanceof EntityPlayer)) {
            par2 = (par2 + 1.0f) / 2.0f;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public boolean func_70652_k(Entity par1Entity) {
        return par1Entity.func_70097_a((DamageSource)new EntityDamageSource("slimeling", (Entity)this), this.getDamage());
    }

    public float getDamage() {
        int i = this.func_70909_n() ? 5 : 2;
        return (float)i * this.getAttackDamage();
    }

    public void func_70903_f(boolean par1) {
        super.func_70903_f(par1);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getMaxHealthSlimeling());
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (this.func_70909_n()) {
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77973_b() == this.getFavoriteFood()) {
                    GCPlayerStats stats;
                    if (this.func_152114_e((EntityLivingBase)player)) {
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        }
                        if (this.field_70170_p.field_72995_K) {
                            MarsModuleClient.openSlimelingGui(this, 1);
                        }
                        if (this.field_70146_Z.nextInt(3) == 0) {
                            this.setRandomFavFood();
                        }
                    } else if (player instanceof EntityPlayerMP && (stats = GCPlayerStats.get((Entity)player)).getChatCooldown() == 0) {
                        player.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate((String)"gui.slimeling.chat.wrong_player")));
                        stats.setChatCooldown(100);
                    }
                } else if (this.field_70170_p.field_72995_K) {
                    MarsModuleClient.openSlimelingGui(this, 0);
                }
            } else if (this.field_70170_p.field_72995_K) {
                MarsModuleClient.openSlimelingGui(this, 0);
            }
            return true;
        }
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151123_aH) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (itemstack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_70903_f(true);
                    this.func_70661_as().func_75499_g();
                    this.func_70624_b(null);
                    this.setSittingAI(true);
                    this.func_70606_j(20.0f);
                    this.func_184754_b(player.func_110124_au());
                    this.setOwnerUsername(player.func_70005_c_());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void setSittingAI(boolean sitting) {
        this.field_70911_d.func_75270_a(sitting);
    }

    public String getOwnerUsername() {
        String s = (String)this.field_70180_af.func_187225_a(OWNER_USERNAME);
        return s == null || s.length() == 0 ? "" : s;
    }

    public void setOwnerUsername(String username) {
        this.field_70180_af.func_187227_b(OWNER_USERNAME, (Object)username);
    }

    public boolean func_70877_b(ItemStack par1ItemStack) {
        return false;
    }

    public EntitySlimeling spawnBabyAnimal(EntityAgeable par1EntityAgeable) {
        if (par1EntityAgeable instanceof EntitySlimeling) {
            EntitySlimeling otherSlimeling = (EntitySlimeling)par1EntityAgeable;
            Vector3 colorParentA = new Vector3((double)this.getColorRed(), (double)this.getColorGreen(), (double)this.getColorBlue());
            Vector3 colorParentB = new Vector3((double)otherSlimeling.getColorRed(), (double)otherSlimeling.getColorGreen(), (double)otherSlimeling.getColorBlue());
            Vector3 newColor = ColorUtil.addColorsRealistically((Vector3)colorParentA, (Vector3)colorParentB);
            newColor.x = Math.max(Math.min(newColor.x, 1.0), 0.0);
            newColor.y = Math.max(Math.min(newColor.y, 1.0), 0.0);
            newColor.z = Math.max(Math.min(newColor.z, 1.0), 0.0);
            EntitySlimeling newSlimeling = new EntitySlimeling(this.field_70170_p, (float)newColor.x, (float)newColor.y, (float)newColor.z);
            UUID s = this.func_184753_b();
            if (s != null) {
                newSlimeling.func_184754_b(s);
                newSlimeling.func_70903_f(true);
            }
            return newSlimeling;
        }
        return null;
    }

    public boolean func_70878_b(EntityAnimal par1EntityAnimal) {
        if (par1EntityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(par1EntityAnimal instanceof EntitySlimeling)) {
            return false;
        }
        EntitySlimeling slimeling = (EntitySlimeling)par1EntityAnimal;
        return slimeling.func_70909_n() && !slimeling.func_70906_o() && this.func_70880_s() && slimeling.func_70880_s();
    }

    public boolean func_142018_a(EntityLivingBase toAttack, EntityLivingBase owner) {
        if (!(toAttack instanceof EntityCreeper) && !(toAttack instanceof EntityGhast)) {
            EntitySlimeling slimeling;
            if (toAttack instanceof EntitySlimeling && (slimeling = (EntitySlimeling)toAttack).func_70909_n() && slimeling.func_70902_q() == owner) {
                return false;
            }
            return !(toAttack instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)toAttack) || toAttack instanceof EntityHorse && ((EntityHorse)toAttack).func_110248_bS());
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAgeable) {
        return this.spawnBabyAnimal(par1EntityAgeable);
    }

    public float getColorRed() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_RED)).floatValue();
    }

    public void setColorRed(float color) {
        this.field_70180_af.func_187227_b(COLOR_RED, (Object)Float.valueOf(color));
    }

    public float getColorGreen() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_GREEN)).floatValue();
    }

    public void setColorGreen(float color) {
        this.field_70180_af.func_187227_b(COLOR_GREEN, (Object)Float.valueOf(color));
    }

    public float getColorBlue() {
        return ((Float)this.field_70180_af.func_187225_a(COLOR_BLUE)).floatValue();
    }

    public void setColorBlue(float color) {
        this.field_70180_af.func_187227_b(COLOR_BLUE, (Object)Float.valueOf(color));
    }

    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public String func_70005_c_() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public void setName(String name) {
        this.field_70180_af.func_187227_b(NAME, (Object)name);
    }

    public Item getFavoriteFood() {
        return Item.func_150899_d((int)((Integer)this.field_70180_af.func_187225_a(FAV_FOOD_ID)));
    }

    public void setFavoriteFood(int foodID) {
        this.field_70180_af.func_187227_b(FAV_FOOD_ID, (Object)foodID);
    }

    public float getAttackDamage() {
        return ((Float)this.field_70180_af.func_187225_a(ATTACK_DAMAGE)).floatValue();
    }

    public void setAttackDamage(float damage) {
        this.field_70180_af.func_187227_b(ATTACK_DAMAGE, (Object)Float.valueOf(damage));
    }

    public int getKillCount() {
        return (Integer)this.field_70180_af.func_187225_a(KILLS);
    }

    public void setKillCount(int damage) {
        this.field_70180_af.func_187227_b(KILLS, (Object)damage);
    }

    public boolean canBreath() {
        return true;
    }

    public float getScale() {
        float f = this.getAge();
        ((Object)((Object)this)).getClass();
        return f / 100000.0f * 0.5f + 0.5f;
    }

    public EntityAISit getAiSit() {
        return this.field_70911_d;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        ItemStack bag;
        super.func_70645_a(p_70645_1_);
        if (!this.field_70170_p.field_72995_K && (bag = this.slimelingInventory.func_70301_a(1)) != null && bag.func_77973_b() == MarsItems.marsItemBasic && bag.func_77952_i() == 4) {
            this.slimelingInventory.func_70298_a(1, 64);
            this.func_70099_a(bag, 0.5f);
        }
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.48 / (double)WorldUtil.getGravityFactor((Entity)this);
        if (this.field_70181_x < 0.28) {
            this.field_70181_x = 0.28;
        }
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z / 57.295776f;
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    public static class EntityAISitGC
    extends EntityAISit {
        private EntityTameable theEntity;
        private boolean isSitting;

        public EntityAISitGC(EntityTameable theEntity) {
            super(theEntity);
            this.theEntity = theEntity;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            if (!this.theEntity.func_70909_n()) {
                return false;
            }
            if (this.theEntity.func_70090_H()) {
                return false;
            }
            EntityLivingBase e = this.theEntity.func_70902_q();
            if (e instanceof EntityLivingBase) {
                EntityLivingBase living = e;
                return living == null ? true : (this.theEntity.func_70068_e((Entity)living) < 144.0 && living.func_70643_av() != null ? false : this.isSitting);
            }
            return false;
        }

        public void func_75249_e() {
            this.theEntity.func_70661_as().func_75499_g();
            this.theEntity.func_70904_g(true);
        }

        public void func_75251_c() {
            this.theEntity.func_70904_g(false);
        }

        public void func_75270_a(boolean isSitting) {
            this.isSitting = isSitting;
        }
    }
}

