/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.ISyncValue;
import sonar.core.sync.IValueWatcher;

public class ValueWatcher
implements IValueWatcher {
    public List<ISonarValue> watched_values = new ArrayList<ISonarValue>();
    public List<IValueWatcher> subWatchers = new ArrayList<IValueWatcher>();
    public boolean dirty;

    public ValueWatcher() {
    }

    public ValueWatcher(IValueWatcher subWatcher) {
        this.addSubWatcher(subWatcher);
    }

    @Override
    public void addSyncValue(ISonarValue value) {
        Preconditions.checkState((!this.watched_values.contains(value) ? 1 : 0) != 0);
        this.watched_values.add(value);
        this.subWatchers.forEach(watcher -> watcher.addSyncValue(value));
    }

    @Override
    public void removeSyncValue(ISonarValue value) {
        Preconditions.checkState((boolean)this.watched_values.contains(value));
        this.watched_values.remove(value);
        this.subWatchers.forEach(watcher -> watcher.removeSyncValue(value));
    }

    @Override
    public void onSyncValueChanged(ISonarValue value) {
        Preconditions.checkState((boolean)this.watched_values.contains(value));
        this.setDirty(true);
        this.subWatchers.forEach(watcher -> watcher.onSyncValueChanged(value));
    }

    public void addSubWatcher(IValueWatcher watcher) {
        this.subWatchers.add(watcher);
    }

    public void removeSubWatcher(IValueWatcher watcher) {
        this.subWatchers.remove(watcher);
    }

    public void forEachSyncable(Consumer<ISyncValue> action) {
        this.watched_values.forEach(v -> {
            if (v instanceof ISyncValue) {
                action.accept((ISyncValue)v);
            }
        });
    }

    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

