/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DungeonStartIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.PieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.SizedPieceIo;
import galaxyspace.systems.SolarSystem.planets.ceres.blocks.CeresBlocks;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class RoomEmptyIo
extends SizedPieceIo {
    public RoomEmptyIo() {
    }

    public RoomEmptyIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(4) + 6, configuration.getRoomHeight(), rand.nextInt(4) + 6, entranceDir);
    }

    public RoomEmptyIo(DungeonConfiguration configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random random, StructureBoundingBox boundingBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || j == this.sizeY || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < this.configuration.getHallwayHeight() && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < this.configuration.getHallwayHeight() && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            if (j == this.configuration.getHallwayHeight()) {
                                this.func_175811_a(worldIn, GSBlocks.CERES_BLOCKS.func_176223_P().func_177226_a(CeresBlocks.BASIC_TYPE, (Comparable)((Object)CeresBlocks.EnumCeresBlocks.CERES_DUNGEON_TOP)), i, j, k, boundingBox);
                                continue;
                            }
                            if (j == 0) {
                                this.func_175811_a(worldIn, GSBlocks.CERES_BLOCKS.func_176223_P().func_177226_a(CeresBlocks.BASIC_TYPE, (Comparable)((Object)CeresBlocks.EnumCeresBlocks.CERES_DUNGEON_FLOOR)), i, j, k, boundingBox);
                                continue;
                            }
                            this.func_175811_a(worldIn, this.configuration.getBrickBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                }
            }
        }
        return true;
    }

    @Override
    public PieceIo getNextPiece(DungeonStartIo startPiece, Random rand) {
        if (Math.abs(startPiece.func_74874_b().field_78892_f - this.field_74887_e.field_78896_c) > 200) {
            return null;
        }
        if (Math.abs(startPiece.func_74874_b().field_78893_d - this.field_74887_e.field_78897_a) > 200) {
            return null;
        }
        return this.getCorridor(rand, startPiece, 10, false);
    }
}

