/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.energy;

import cofh.thermaldynamics.duct.energy.DuctUnitEnergy;
import cofh.thermaldynamics.duct.energy.GridEnergy;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import java.util.Iterator;
import net.minecraft.world.World;

public class GridEnergySuper
extends GridEnergy {
    int nodeTracker;
    boolean isSendingEnergy;
    DuctUnitEnergy[] nodeList = null;

    public GridEnergySuper(World world, int transferLimit, int capacity) {
        super(world, transferLimit, capacity);
        this.myStorage.setMaxExtract(this.myStorage.getMaxEnergyStored());
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        int i = 0;
        if (this.nodeList == null) {
            this.nodeList = new DuctUnitEnergy[this.nodeSet.size()];
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                DuctUnitEnergy multiBlock;
                this.nodeList[i] = multiBlock = (DuctUnitEnergy)iterator.next();
                ++i;
            }
        }
    }

    @Override
    public int receiveEnergy(int energy, boolean simulate) {
        int i;
        if (this.isSendingEnergy) {
            return 0;
        }
        int tempTracker = this.nodeTracker;
        DuctUnitEnergy[] list = this.nodeList;
        if (list == null || list.length == 0) {
            return 0;
        }
        int startAmount = energy;
        this.isSendingEnergy = true;
        for (i = this.nodeTracker; i < list.length && energy > 0; ++i) {
            if ((energy -= this.trackInOut(list[i].transmitEnergy(energy, simulate), simulate)) != 0) continue;
            this.nodeTracker = i + 1;
        }
        for (i = 0; i < list.length && i < this.nodeTracker && energy > 0; ++i) {
            if ((energy -= this.trackInOut(list[i].transmitEnergy(energy, simulate), simulate)) != 0) continue;
            this.nodeTracker = i + 1;
        }
        if (energy > 0) {
            ++this.nodeTracker;
        }
        if (this.nodeTracker >= list.length) {
            this.nodeTracker = 0;
        }
        if (simulate) {
            this.nodeTracker = tempTracker;
        }
        this.isSendingEnergy = false;
        return startAmount - energy;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.nodeList = null;
    }

    @Override
    public boolean canGridsMerge(MultiBlockGrid grid) {
        return grid instanceof GridEnergySuper;
    }

    @Override
    public void destroy() {
        this.nodeList = null;
        super.destroy();
    }
}

