/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.part;

import appeng.api.parts.IPartCollisionHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.IConfigManager;
import appeng.me.GridAccessException;
import net.minecraft.nbt.NBTTagCompound;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.integration.appeng.util.ThEConfigManager;
import thaumicenergistics.item.ItemPartBase;
import thaumicenergistics.part.PartBase;

public abstract class PartSharedTerminal
extends PartBase
implements ITerminalHost {
    private IConfigManager cm = new ThEConfigManager();

    public PartSharedTerminal(ItemPartBase item) {
        super(item);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.getConfigManager().readFromNBT(nbt);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.getConfigManager().writeToNBT(nbt);
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        try {
            return GridUtil.getStorageGrid(this).getInventory(channel);
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.5;
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    public IConfigManager getConfigManager() {
        return this.cm;
    }
}

