/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import cubex2.cs4.plugins.vanilla.ContentBlockFluid;
import cubex2.cs4.plugins.vanilla.FluidModifier;
import cubex2.cs4.plugins.vanilla.Fuel;
import cubex2.cs4.plugins.vanilla.block.CSBlock;
import net.minecraft.block.Block;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    @SubscribeEvent
    public static void canCreateFluidSource(BlockEvent.CreateFluidSourceEvent event) {
        Object content;
        if (event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        if (EventHandler.applyModifiers(event)) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (block instanceof CSBlock && (content = ((CSBlock)block).getContent()) instanceof ContentBlockFluid) {
            ContentBlockFluid fluid = (ContentBlockFluid)content;
            event.setResult(fluid.canCreateSource ? Event.Result.ALLOW : Event.Result.DENY);
        }
    }

    private static boolean applyModifiers(BlockEvent.CreateFluidSourceEvent event) {
        Block block = event.getState().func_177230_c();
        for (FluidModifier modifier : FluidModifier.getModifiers()) {
            if (block.getRegistryName() == null || !block.getRegistryName().equals((Object)modifier.block) || modifier.canCreateSource == null) continue;
            event.setResult(modifier.canCreateSource != false ? Event.Result.ALLOW : Event.Result.DENY);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void furnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        for (Fuel fuel : Fuel.INSTANCES) {
            if (!fuel.appliesToStack(event.getItemStack())) continue;
            event.setBurnTime(fuel.burnTime);
            break;
        }
    }
}

