/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.mffs.common;

import com.google.common.collect.MapMaker;
import com.nekokittygames.mffs.api.PointXYZ;
import com.nekokittygames.mffs.common.ForceFieldBlockStack;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public final class WorldMap {
    private static Map<World, ForceFieldWorld> ForceFieldWorlds = new MapMaker().weakKeys().makeMap();

    public static ForceFieldWorld getForceFieldWorld(World world) {
        if (world != null) {
            if (!ForceFieldWorlds.containsKey(world)) {
                ForceFieldWorlds.put(world, new ForceFieldWorld());
            }
            return ForceFieldWorlds.get(world);
        }
        return null;
    }

    public static class ForceFieldWorld {
        private static Map<Integer, ForceFieldBlockStack> ForceFieldStackMap = new Hashtable<Integer, ForceFieldBlockStack>();

        public ForceFieldBlockStack getorcreateFFStackMap(BlockPos pos, World world) {
            PointXYZ png = new PointXYZ(pos, world);
            if (ForceFieldStackMap.get(png.hashCode()) == null) {
                ForceFieldStackMap.put(png.hashCode(), new ForceFieldBlockStack(png));
            }
            return ForceFieldStackMap.get(png.hashCode());
        }

        public ForceFieldBlockStack getForceFieldStackMap(Integer hasher) {
            return ForceFieldStackMap.get(hasher);
        }

        public ForceFieldBlockStack getForceFieldStackMap(PointXYZ png) {
            return ForceFieldStackMap.get(png.hashCode());
        }

        public int isExistForceFieldStackMap(BlockPos pos, int counter, int typ, World world) {
            BlockPos newPos = new BlockPos((Vec3i)pos);
            switch (typ) {
                case 0: {
                    newPos = newPos.func_177982_a(0, counter, 0);
                    break;
                }
                case 1: {
                    newPos = newPos.func_177982_a(0, -counter, 0);
                    break;
                }
                case 2: {
                    newPos = newPos.func_177982_a(0, 0, counter);
                    break;
                }
                case 3: {
                    newPos = newPos.func_177982_a(0, 0, -counter);
                    break;
                }
                case 4: {
                    newPos = newPos.func_177982_a(counter, 0, 0);
                    break;
                }
                case 5: {
                    newPos = newPos.func_177982_a(-counter, 0, 0);
                }
            }
            ForceFieldBlockStack Map2 = ForceFieldStackMap.get(new PointXYZ(newPos, world).hashCode());
            if (Map2 == null) {
                return 0;
            }
            if (Map2.isEmpty()) {
                return 0;
            }
            return Map2.getGenratorID();
        }
    }
}

