/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.tools;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import cofh.redstoneflux.api.IEnergyContainerItem;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import landmaster.plustic.api.Sounds;
import landmaster.plustic.api.event.PTEnergyDrain;
import landmaster.plustic.modules.ModuleTools;
import landmaster.plustic.net.PacketHandler;
import landmaster.plustic.net.PacketLaserGunZapBlock;
import landmaster.plustic.tools.IEnumL10n;
import landmaster.plustic.tools.IToggleTool;
import landmaster.plustic.tools.nbt.LaserNBT;
import landmaster.plustic.tools.nbt.ToolEnergyNBT;
import landmaster.plustic.tools.stats.BatteryCellMaterialStats;
import landmaster.plustic.tools.stats.LaserMediumMaterialStats;
import landmaster.plustic.util.ClientUtils;
import landmaster.plustic.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.EntityUtil;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux"), @Optional.Interface(iface="appeng.api.implementations.items.IAEItemPowerStorage", modid="appliedenergistics2")})
public class ToolLaserGun
extends TinkerToolCore
implements IEnergyContainerItem,
IAEItemPowerStorage,
IToggleTool<Mode> {
    public static final String ATTACK_DURATION_TAG = "AttackDuration";
    public static final String MODE_TAG = "Mode";
    public static final String POS_LCOOL_TAG = "LockCooldown";
    public static final String ENERGY_NBT = "Energy";
    public static final ResourceLocation LASER_LOC = new ResourceLocation("plustic", "textures/effects/laserbeam.png");
    @SidedProxy(serverSide="landmaster.plustic.tools.ToolLaserGun$Proxy", clientSide="landmaster.plustic.tools.ToolLaserGun$ProxyClient")
    public static Proxy proxy;

    private static float range(ItemStack is) {
        return new LaserNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)is)).range;
    }

    private int maxAttackDuration(ItemStack is) {
        return (int)(20.0f / ToolHelper.getActualAttackSpeed((ItemStack)is));
    }

    private int energyPerAttack(ItemStack is) {
        return 100;
    }

    private static int getFullEnergy(ItemStack is) {
        return new ToolEnergyNBT((NBTTagCompound)TagUtil.getToolTag((ItemStack)is)).energy;
    }

    private static Optional<ItemStack> getActiveLaserGun(EntityLivingBase entity) {
        return Arrays.stream(EnumHand.values()).map(arg_0 -> ((EntityLivingBase)entity).func_184586_b(arg_0)).filter(stack -> stack != null && stack.func_77973_b() instanceof ToolLaserGun && TagUtil.getTagSafe((ItemStack)stack).func_74762_e(ATTACK_DURATION_TAG) > 0).findFirst();
    }

    public static RayTraceResult trace(Mode mode, EntityPlayer entity, float range) {
        switch (mode) {
            case ATTACK: {
                return EntityUtil.raytraceEntityPlayerLook((EntityPlayer)entity, (float)range);
            }
            case TOOL: {
                return entity.func_130014_f_().func_72933_a(entity.func_174824_e(1.0f), entity.func_174824_e(1.0f).func_178787_e(entity.func_70676_i(1.0f).func_186678_a((double)range)));
            }
        }
        throw new RuntimeException("Bad mode, you copycat!");
    }

    public ToolLaserGun() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), PartMaterialType.head((IToolPart)ModuleTools.pipe_piece), new PartMaterialType((IToolPart)ModuleTools.laser_medium, new String[]{"laser_medium"}), new PartMaterialType((IToolPart)ModuleTools.battery_cell, new String[]{"battery_cell"})});
        this.addCategory(new Category[]{Category.WEAPON});
        proxy.initEvents();
        this.func_77655_b("laser_gun").setRegistryName("laser_gun");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)stack);
            int atkDur = nbt.func_74762_e(ATTACK_DURATION_TAG);
            if (--atkDur < 0) {
                atkDur = 0;
            }
            nbt.func_74768_a(ATTACK_DURATION_TAG, atkDur);
            stack.func_77982_d(nbt);
            nbt.func_74768_a(POS_LCOOL_TAG, MathHelper.func_76125_a((int)(nbt.func_74762_e(POS_LCOOL_TAG) - 1), (int)0, (int)Integer.MAX_VALUE));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)list, new Material[]{null, null, TinkerMaterials.prismarine, TinkerMaterials.manyullyn});
        }
    }

    protected LaserNBT buildTagData(List<Material> materials) {
        LaserNBT nbt = new LaserNBT();
        nbt.head(new HeadMaterialStats[]{(HeadMaterialStats)materials.get(1).getStatsOrUnknown("head")});
        nbt.handle(new HandleMaterialStats[]{(HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle")});
        nbt.laserMedium((LaserMediumMaterialStats)materials.get(2).getStatsOrUnknown("laser_medium"));
        nbt.batteryCell((BatteryCellMaterialStats)materials.get(3).getStatsOrUnknown("battery_cell"));
        return nbt;
    }

    public float damagePotential() {
        return 1.0f;
    }

    public double attackSpeed() {
        return 3.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Optional.ofNullable(IToggleTool.getMode(stack, Mode.class)).ifPresent(mode -> tooltip.add(I18n.func_135052_a((String)"msg.plustic.tool_mode", (Object[])new Object[]{I18n.func_135052_a((String)mode.getUnlocName(), (Object[])new Object[0])})));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        ArrayList<String> list = new ArrayList<String>();
        TooltipBuilder info = new TooltipBuilder(stack);
        info.addDurability(!detailed);
        info.add(String.format(TextFormatting.AQUA + "%s RF / %s RF", this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
        info.addAttack();
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        list.addAll(info.getTooltip());
        return list;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return this._rightClick(playerIn.func_184586_b(hand), worldIn, playerIn, hand);
    }

    protected ActionResult<ItemStack> _rightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        }
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)itemStackIn);
        ActionResult res = new ActionResult(EnumActionResult.PASS, (Object)itemStackIn);
        if (IToggleTool.getMode(itemStackIn, Mode.class) == Mode.ATTACK) {
            res = Optional.ofNullable(Utils.raytraceEntityPlayerLookWithPred(playerIn, ToolLaserGun.range(itemStackIn), (Predicate<? super Entity>)((Predicate)ent -> !(ent instanceof IEntityMultiPart)))).map(rtr -> rtr.field_72308_g).map(ent -> {
                PTEnergyDrain eevent = new PTEnergyDrain(itemStackIn, playerIn, this.energyPerAttack(itemStackIn));
                MinecraftForge.EVENT_BUS.post((Event)eevent);
                int energyTaken = eevent.energyDrained;
                if (this.extractEnergy(itemStackIn, energyTaken, true) >= energyTaken && nbt.func_74762_e(ATTACK_DURATION_TAG) <= 0 && ToolHelper.attackEntity((ItemStack)itemStackIn, (ToolCore)this, (EntityLivingBase)playerIn, (Entity)ent)) {
                    this.extractEnergy(itemStackIn, energyTaken, false);
                    nbt.func_74768_a(ATTACK_DURATION_TAG, this.maxAttackDuration(itemStackIn));
                    itemStackIn.func_77982_d(nbt);
                    Sounds.playSoundToAll((Entity)playerIn, Sounds.LASER_BEAM, 1.0f, 1.0f);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
                }
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
            }).orElse(new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn));
        }
        return res;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (IToggleTool.getMode(stack, Mode.class) == Mode.TOOL) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_74762_e(POS_LCOOL_TAG) > 0) {
                return EnumActionResult.FAIL;
            }
            ItemStack smeltingRes = ItemStack.field_190927_a;
            IBlockState state = worldIn.func_180495_p(pos);
            smeltingRes = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state))).func_77946_l();
            if (!smeltingRes.func_190926_b()) {
                PTEnergyDrain eevent = new PTEnergyDrain(stack, player, this.energyPerAttack(stack));
                MinecraftForge.EVENT_BUS.post((Event)eevent);
                int energyTaken = eevent.energyDrained;
                if (this.extractEnergy(stack, energyTaken, true) >= energyTaken) {
                    this.extractEnergy(stack, energyTaken, false);
                    worldIn.func_175655_b(pos, false);
                    worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, smeltingRes));
                    nbt.func_74768_a(POS_LCOOL_TAG, MathHelper.func_76123_f((float)(220.0f / ToolHelper.getActualMiningSpeed((ItemStack)stack))));
                    if (player instanceof EntityPlayerMP) {
                        PacketHandler.INSTANCE.sendTo((IMessage)new PacketLaserGunZapBlock(new Vec3d((double)hitX, (double)hitY, (double)hitZ), EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())), (EntityPlayerMP)player);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return EnumActionResult.PASS;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)this._receiveEnergy(container, maxReceive, simulate);
    }

    protected double _receiveEnergy(ItemStack container, double maxReceive, boolean simulate) {
        if (!container.func_77942_o()) {
            container.func_77982_d(new NBTTagCompound());
        }
        double energy = container.func_77978_p().func_74769_h(ENERGY_NBT);
        double energyReceived = Math.min((double)ToolLaserGun.getFullEnergy(container) - energy, Math.min((double)ToolLaserGun.getFullEnergy(container), maxReceive));
        if (!simulate) {
            container.func_77978_p().func_74780_a(ENERGY_NBT, energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)this._extractEnergy(container, maxExtract, simulate);
    }

    protected double _extractEnergy(ItemStack container, double maxExtract, boolean simulate) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(ENERGY_NBT)) {
            return 0.0;
        }
        double energy = container.func_77978_p().func_74769_h(ENERGY_NBT);
        double energyExtracted = Math.min(energy, Math.min((double)ToolLaserGun.getFullEnergy(container), maxExtract));
        if (!simulate) {
            container.func_77978_p().func_74780_a(ENERGY_NBT, energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null || !container.func_77978_p().func_74764_b(ENERGY_NBT)) {
            return 0;
        }
        return container.func_77978_p().func_74762_e(ENERGY_NBT);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return ToolLaserGun.getFullEnergy(container);
    }

    public ICapabilityProvider initCapabilities(ItemStack is, NBTTagCompound capNbt) {
        return new Provider(is);
    }

    @Override
    public Class<Mode> clazz() {
        return Mode.class;
    }

    @Override
    public String getTag() {
        return MODE_TAG;
    }

    @Optional.Method(modid="appliedenergistics2")
    public double extractAEPower(ItemStack arg0, double arg1, Actionable arg2) {
        return PowerUnits.RF.convertTo(PowerUnits.AE, this._extractEnergy(arg0, PowerUnits.AE.convertTo(PowerUnits.RF, arg1), arg2 == Actionable.SIMULATE));
    }

    public double getAECurrentPower(ItemStack arg0) {
        if (arg0.func_77978_p() == null || !arg0.func_77978_p().func_74764_b(ENERGY_NBT)) {
            return 0.0;
        }
        return PowerUnits.RF.convertTo(PowerUnits.AE, arg0.func_77978_p().func_74769_h(ENERGY_NBT));
    }

    public double getAEMaxPower(ItemStack arg0) {
        return PowerUnits.RF.convertTo(PowerUnits.AE, (double)this.getMaxEnergyStored(arg0));
    }

    @Optional.Method(modid="appliedenergistics2")
    public AccessRestriction getPowerFlow(ItemStack arg0) {
        return AccessRestriction.READ_WRITE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public double injectAEPower(ItemStack arg0, double arg1, Actionable arg2) {
        return arg1 - PowerUnits.RF.convertTo(PowerUnits.AE, this._receiveEnergy(arg0, PowerUnits.AE.convertTo(PowerUnits.RF, arg1), arg2 == Actionable.SIMULATE));
    }

    private class Provider
    implements ICapabilityProvider {
        Energy energy;

        public Provider(ItemStack is) {
            this.energy = new Energy(is);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this.energy;
            }
            return null;
        }
    }

    private class Energy
    implements IEnergyStorage {
        ItemStack is;

        public Energy(ItemStack is) {
            this.is = is;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return ToolLaserGun.this.receiveEnergy(this.is, maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return ToolLaserGun.this.extractEnergy(this.is, maxExtract, simulate);
        }

        public int getEnergyStored() {
            return ToolLaserGun.this.getEnergyStored(this.is);
        }

        public int getMaxEnergyStored() {
            return ToolLaserGun.this.getMaxEnergyStored(this.is);
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static class ProxyClient
    extends Proxy {
        private static final Map<EntityPlayer, Vec3d> zapBlockRend = new WeakHashMap<EntityPlayer, Vec3d>();

        @Override
        public void addToZapBlockRendering(EntityPlayer shooter, Vec3d target) {
            zapBlockRend.put(shooter, target);
        }

        @Override
        public void initEvents() {
            super.initEvents();
            MinecraftForge.EVENT_BUS.register(ProxyClient.class);
        }

        @SubscribeEvent
        public static void renderBeam(RenderWorldLastEvent event) {
            Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).ifPresent(ProxyClient::doRenderBeam);
        }

        @SubscribeEvent
        public static void renderBeam(RenderPlayerEvent.Pre event) {
            if (!event.getEntityPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                ProxyClient.doRenderBeam((EntityLivingBase)event.getEntityPlayer());
            }
        }

        @SubscribeEvent
        public static void renderBeam(RenderLivingEvent.Pre<?> event) {
            if (!(event.getEntity() instanceof EntityPlayer)) {
                ProxyClient.doRenderBeam(event.getEntity());
            }
        }

        public static void doRenderBeam(EntityLivingBase shooter) {
            ToolLaserGun.getActiveLaserGun(shooter).ifPresent(stack -> {
                Vec3d vec0;
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)1, (int)1);
                GlStateManager.func_179094_E();
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                float partialTicks = Minecraft.func_71410_x().func_184121_ak();
                double doubleX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
                double doubleY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
                double doubleZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
                Vec3d vec = new Vec3d(doubleX, doubleY + (double)player.func_70047_e(), doubleZ);
                Vec3d vec1 = vec0 = shooter.func_174791_d().func_72441_c(0.0, (double)shooter.func_70047_e() + 0.2, 0.0);
                switch (IToggleTool.getMode(stack, Mode.class)) {
                    case ATTACK: {
                        vec1 = Optional.ofNullable(EntityUtil.raytraceEntityPlayerLook((EntityPlayer)player, (float)ToolLaserGun.range(stack))).map(rtr -> rtr.field_72307_f).orElse(vec1);
                        break;
                    }
                    case TOOL: {
                        if (!zapBlockRend.containsKey(shooter)) break;
                        vec1 = zapBlockRend.get(shooter);
                        zapBlockRend.remove(shooter);
                        break;
                    }
                }
                GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(LASER_LOC);
                buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                ClientUtils.drawBeam(vec0, vec1, vec, 0.13f);
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179112_b((int)770, (int)771);
            });
        }
    }

    public static class Proxy {
        public void initEvents() {
            MinecraftForge.EVENT_BUS.register(Proxy.class);
        }

        public void addToZapBlockRendering(EntityPlayer shooter, Vec3d target) {
        }
    }

    public static enum Mode implements IEnumL10n
    {
        ATTACK,
        TOOL;


        @Override
        public String getUnlocName() {
            return "mode.laser_gun." + this.name().toLowerCase(Locale.US);
        }
    }
}

