/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.util;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import landmaster.plustic.util.Coord4D;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DoubleCoord4D {
    public double xCoord;
    public double yCoord;
    public double zCoord;
    public int dimensionId;

    public DoubleCoord4D(Coord4D coord) {
        this.xCoord = coord.xCoord;
        this.yCoord = coord.yCoord;
        this.zCoord = coord.zCoord;
        this.dimensionId = coord.dimensionId;
    }

    public DoubleCoord4D(Entity ent) {
        this.xCoord = ent.field_70165_t;
        this.yCoord = ent.field_70163_u;
        this.zCoord = ent.field_70161_v;
        this.dimensionId = ent.field_71093_bK;
    }

    public DoubleCoord4D(double x, double y, double z, int dimension) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimensionId = dimension;
    }

    public DoubleCoord4D(Vec3d pos, World world) {
        this(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, world.field_73011_w.getDimension());
    }

    public static Coord4D fromNBT(NBTTagCompound nbt) {
        if (nbt.func_186856_d() == 0) {
            return null;
        }
        return new Coord4D(nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"), nbt.func_74762_e("dim"));
    }

    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        nbt.func_74780_a("x", this.xCoord);
        nbt.func_74780_a("y", this.yCoord);
        nbt.func_74780_a("z", this.zCoord);
        nbt.func_74768_a("dim", this.dimensionId);
        return nbt;
    }

    public static Coord4D fromByteBuf(ByteBuf bb) {
        return new Coord4D(bb.readDouble(), bb.readDouble(), bb.readDouble(), bb.readInt());
    }

    public ByteBuf toByteBuf(ByteBuf bb) {
        return bb.writeDouble(this.xCoord).writeDouble(this.yCoord).writeDouble(this.zCoord).writeInt(this.dimensionId);
    }

    public Coord4D add(double x, double y, double z) {
        return new Coord4D(this.xCoord + x, this.yCoord + y, this.zCoord + z, this.dimensionId);
    }

    public Vec3d vec() {
        return new Vec3d(this.xCoord, this.yCoord, this.zCoord);
    }

    public WorldServer world() {
        return DimensionManager.getWorld((int)this.dimensionId);
    }

    public String toString() {
        return String.format(Locale.US, "[x=%f, y=%f, z=%f] @ dimension %d", this.xCoord, this.yCoord, this.zCoord, this.dimensionId);
    }

    public boolean equals(Object obj) {
        return obj instanceof DoubleCoord4D && ((DoubleCoord4D)obj).xCoord == this.xCoord && ((DoubleCoord4D)obj).yCoord == this.yCoord && ((DoubleCoord4D)obj).zCoord == this.zCoord && ((DoubleCoord4D)obj).dimensionId == this.dimensionId;
    }
}

