/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wit.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.misc.PartInterface;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterface;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.WrapperRangeItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTGuiObject;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.wit.api.IWirelessInterfaceTerminalItem;
import p455w0rd.wit.init.ModNetworking;
import p455w0rd.wit.sync.packets.PacketCompressedNBT;
import p455w0rd.wit.sync.packets.PacketInventoryAction;
import p455w0rd.wit.sync.packets.PacketTargetItemStack;

public class ContainerWIT
extends ContainerWT {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IInterfaceHost, InvTracker> diList = new HashMap<IInterfaceHost, InvTracker>();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();
    private IAEItemStack clientRequestedTargetItem = null;

    public ContainerWIT(EntityPlayer player, ITerminalHost hostIn, int slot, boolean isBauble) {
        super(player.field_71071_by, (Object)ContainerWIT.getActionHost((Object)ContainerWIT.getGuiObject((ItemStack)(isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(player, slot, IWirelessInterfaceTerminalItem.class) : WTApi.instance().getWTBySlot(player, slot)), (EntityPlayer)player)), slot, isBauble, true, 152, 120);
        this.setCustomName("WITContainer");
        this.setTerminalHost(hostIn);
        this.initConfig(this.setClientConfigManager((IConfigManager)new ConfigManager((IConfigManagerHost)this)));
        if (Platform.isServer()) {
            this.setServerConfigManager(this.getGuiObject().getConfigManager());
            if (this.getGuiObject() == null || this.getGuiObject().getActionableNode() == null || this.getGuiObject().getActionableNode().getGrid() == null) {
                this.setValidContainer(false);
            } else {
                this.grid = this.getGuiObject().getActionableNode().getGrid();
            }
        }
        this.bindPlayerInventory(player.field_71071_by, 8, 140);
        this.readNBT();
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        ItemStack returnStack = ItemStack.field_190927_a;
        try {
            returnStack = super.func_184996_a(slot, dragType, clickTypeIn, player);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.writeToNBT();
        this.func_75142_b();
        return returnStack;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            if (stack == null && this.clientRequestedTargetItem == null) {
                return;
            }
            if (stack != null && stack.isSameType(this.clientRequestedTargetItem)) {
                return;
            }
            ModNetworking.instance().sendToServer(new PacketTargetItemStack((AEItemStack)stack));
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public void func_75142_b() {
        if (Platform.isServer()) {
            IGridNode agn;
            if (this.getGuiObject() != null) {
                if (this.getWirelessTerminal() != this.getGuiObject().getItemStack()) {
                    if (!this.getWirelessTerminal().func_190926_b()) {
                        if (ItemStack.func_179545_c((ItemStack)this.getGuiObject().getItemStack(), (ItemStack)this.getWirelessTerminal())) {
                            this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.getGuiObject().getItemStack());
                        } else {
                            this.setValidContainer(false);
                        }
                    } else {
                        this.setValidContainer(false);
                    }
                }
            } else {
                this.setValidContainer(false);
            }
            super.func_75142_b();
            if (this.grid == null) {
                return;
            }
            int total = 0;
            boolean missing = false;
            WTGuiObject host = this.getGuiObject();
            if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
                DualityInterface dual;
                InvTracker t;
                IInterfaceHost ih;
                for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                    if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                    t = this.diList.get(ih);
                    if (t == null) {
                        missing = true;
                    } else {
                        dual = ih.getInterfaceDuality();
                        if (!t.unlocalizedName.equals(dual.getTermName())) {
                            missing = true;
                        }
                    }
                    ++total;
                }
                for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                    if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                    t = this.diList.get(ih);
                    if (t == null) {
                        missing = true;
                    } else {
                        dual = ih.getInterfaceDuality();
                        if (!t.unlocalizedName.equals(dual.getTermName())) {
                            missing = true;
                        }
                    }
                    ++total;
                }
            }
            if (total != this.diList.size() || missing) {
                this.regenList(this.data);
            } else {
                for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
                    InvTracker inv = en.getValue();
                    for (int x = 0; x < inv.server.getSlots(); ++x) {
                        if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                        this.addItems(this.data, inv, x, 1);
                    }
                }
            }
            if (!this.data.func_82582_d()) {
                try {
                    ModNetworking.instance().sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.data = new NBTTagCompound();
            }
            if (!this.isInRange()) {
                if (!this.hasInfiniteRange()) {
                    if (this.isValidContainer()) {
                        this.getPlayer().func_145747_a(PlayerMessages.OutOfRange.get());
                    }
                    this.setValidContainer(false);
                }
                if (!this.networkIsPowered()) {
                    if (this.isValidContainer()) {
                        this.getPlayer().func_145747_a((ITextComponent)new TextComponentString("No Network Power"));
                    }
                    this.setValidContainer(false);
                }
            } else if (!(this.hasAccess(SecurityPermissions.CRAFT, true) && this.hasAccess(SecurityPermissions.EXTRACT, true) && this.hasAccess(SecurityPermissions.INJECT, true))) {
                if (this.isValidContainer()) {
                    this.getPlayer().func_145747_a(PlayerMessages.CommunicationError.get());
                }
                this.setValidContainer(false);
            }
            if (this.getWirelessTerminal().func_77973_b() instanceof IWirelessInterfaceTerminalItem && ((IWirelessInterfaceTerminalItem)this.getWirelessTerminal().func_77973_b()).getAECurrentPower(this.getWirelessTerminal()) <= 0.0) {
                if (this.isValidContainer()) {
                    this.getPlayer().func_145747_a((ITextComponent)new TextComponentString("No Power"));
                }
                this.setValidContainer(false);
            }
        }
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack is = inv.server.getStackInSlot(slot);
            boolean hasItemInHand = !player.field_71071_by.func_70445_o().func_190926_b();
            AdaptorItemHandler playerHand = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
            WrapperFilteredItemHandler theSlot = new WrapperFilteredItemHandler((IItemHandler)new WrapperRangeItemHandler(inv.server, slot, slot + 1), (IAEItemFilter)new PatternSlotFilter());
            AdaptorItemHandler interfaceSlot = new AdaptorItemHandler((IItemHandler)theSlot);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        ItemStack inSlot = theSlot.getStackInSlot(0);
                        if (inSlot.func_190926_b()) {
                            player.field_71071_by.func_70437_b(interfaceSlot.addItems(player.field_71071_by.func_70445_o()));
                            break;
                        }
                        inSlot = inSlot.func_77946_l();
                        ItemStack inHand = player.field_71071_by.func_70445_o().func_77946_l();
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(interfaceSlot.addItems(inHand.func_77946_l()));
                        if (player.field_71071_by.func_70445_o().func_190926_b()) {
                            player.field_71071_by.func_70437_b(inSlot);
                            break;
                        }
                        player.field_71071_by.func_70437_b(inHand);
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)inSlot);
                        break;
                    }
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)playerHand.addItems(theSlot.getStackInSlot(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        ItemStack extra = playerHand.removeItems(1, ItemStack.field_190927_a, null);
                        if (!extra.func_190926_b()) {
                            extra = interfaceSlot.addItems(extra);
                        }
                        if (extra.func_190926_b()) break;
                        playerHand.addItems(extra);
                        break;
                    }
                    if (is.func_190926_b()) break;
                    ItemStack extra = interfaceSlot.removeItems((is.func_190916_E() + 1) / 2, ItemStack.field_190927_a, null);
                    if (!extra.func_190926_b()) {
                        extra = playerHand.addItems(extra);
                    }
                    if (extra.func_190926_b()) break;
                    interfaceSlot.addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)playerInv.addItems(theSlot.getStackInSlot(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    for (int x = 0; x < inv.server.getSlots(); ++x) {
                        ItemHandlerUtil.setStackInSlot((IItemHandler)inv.server, (int)x, (ItemStack)playerInvAd.addItems(inv.server.getStackInSlot(x)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || hasItemInHand) break;
                    player.field_71071_by.func_70437_b(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                ModNetworking.instance().sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.fromItemStack((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isPowered() {
        double pwr = ((ICustomWirelessTerminalItem)this.getWirelessTerminal().func_77973_b()).getAECurrentPower(this.getWirelessTerminal());
        return pwr > 0.0;
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        WTGuiObject host = this.getGuiObject();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.server.getSlots());
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return false;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.getStackInSlot(x + offset);
            ItemHandlerUtil.setStackInSlot((IItemHandler)inv.client, (int)(x + offset), (ItemStack)(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l()));
            if (!is.func_190926_b()) {
                is.func_77955_b(itemNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        return ItemStack.field_190927_a;
    }

    static /* synthetic */ long access$608() {
        return autoBase++;
    }

    private static class PatternSlotFilter
    implements IAEItemFilter {
        private PatternSlotFilter() {
        }

        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return true;
        }

        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemEncodedPattern;
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = ContainerWIT.access$608();
        private final String unlocalizedName;
        private final IItemHandler client;
        private final IItemHandler server;

        public InvTracker(DualityInterface dual, IItemHandler patterns, String unlocalizedName) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, this.server.getSlots());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
        }
    }
}

