/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.lib.AncientFurnaceConversion;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.NBTUtil;
import lumien.randomthings.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.biome.Biome;

public class TileEntityAncientFurnace
extends TileEntityBase
implements ITickable {
    STATE state = STATE.IDLE;
    int startingCounter;
    List<BlockPos> toBreak;
    LinkedHashMap<BlockPos, Boolean[]> nextCheckEntries;
    long transformCount;

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("state", this.state.ordinal());
        if (!sync && this.state == STATE.RUNNING) {
            NBTTagList tagList = new NBTTagList();
            for (Map.Entry<BlockPos, Boolean[]> entry : this.nextCheckEntries.entrySet()) {
                NBTTagCompound entryCompound = new NBTTagCompound();
                NBTUtil.writeBlockPosToNBT(entryCompound, "pos", entry.getKey());
                for (int i = 0; i < entry.getValue().length; ++i) {
                    entryCompound.func_74757_a("facing" + i, entry.getValue()[i].booleanValue());
                }
                tagList.func_74742_a((NBTBase)entryCompound);
            }
            compound.func_74782_a("nextCheckEntries", (NBTBase)tagList);
            compound.func_74772_a("transformCount", this.transformCount);
        }
        if (this.state == STATE.STARTING) {
            if (!sync) {
                NBTTagList toBreakTagList = new NBTTagList();
                for (BlockPos p : this.toBreak) {
                    NBTTagCompound posCompound = new NBTTagCompound();
                    NBTUtil.writeBlockPosToNBT(posCompound, "data", p);
                    toBreakTagList.func_74742_a((NBTBase)posCompound);
                }
                compound.func_74782_a("toBreak", (NBTBase)toBreakTagList);
            }
            compound.func_74768_a("startingCounter", this.startingCounter);
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        int i;
        this.state = STATE.values()[compound.func_74762_e("state")];
        if (!sync && this.state == STATE.RUNNING) {
            this.nextCheckEntries = new LinkedHashMap();
            NBTTagList tagList = compound.func_150295_c("nextCheckEntries", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound entryCompound = tagList.func_150305_b(i);
                BlockPos pos = NBTUtil.readBlockPosFromNBT(entryCompound, "pos");
                Boolean[] facingArray = new Boolean[EnumFacing.field_176754_o.length];
                for (int b = 0; b < facingArray.length; ++b) {
                    facingArray[b] = entryCompound.func_74767_n("facing" + b);
                }
                this.nextCheckEntries.put(pos, facingArray);
            }
            this.transformCount = compound.func_74763_f("transformCount");
        }
        if (this.state == STATE.STARTING) {
            if (!sync) {
                this.toBreak = new ArrayList<BlockPos>();
                NBTTagList toBreakTagList = compound.func_150295_c("toBreak", 10);
                for (i = 0; i < toBreakTagList.func_74745_c(); ++i) {
                    this.toBreak.add(NBTUtil.readBlockPosFromNBT(toBreakTagList.func_150305_b(i), "data"));
                }
            }
            this.startingCounter = compound.func_74762_e("startingCounter");
        }
    }

    public void func_73660_a() {
        if (this.state == STATE.RUNNING) {
            if (!this.field_145850_b.field_72995_K) {
                if (!this.nextCheckEntries.isEmpty() && this.transformCount <= (long)Numbers.ANCIENT_FURNACE_LIMIT) {
                    Iterator<Map.Entry<BlockPos, Boolean[]>> iterator = this.nextCheckEntries.entrySet().iterator();
                    Map.Entry<BlockPos, Boolean[]> nextEntry = iterator.next();
                    iterator.remove();
                    BlockPos nextPos = nextEntry.getKey();
                    Biome b = this.field_145850_b.func_180494_b(nextPos);
                    Biome conversion = AncientFurnaceConversion.getHeatingConversion(b);
                    if (conversion != null) {
                        BlockPos topPos = WorldUtil.getHeighestPos(this.field_145850_b, nextPos.func_177958_n(), nextPos.func_177952_p());
                        WorldUtil.setBiome(this.field_145850_b, nextPos, conversion);
                        ++this.transformCount;
                        IBlockState topState = this.field_145850_b.func_180495_p(topPos);
                        if (topState.func_177230_c() == Blocks.field_150431_aC) {
                            this.field_145850_b.func_175698_g(topPos);
                        } else if (topState.func_177230_c() == Blocks.field_150432_aD) {
                            this.field_145850_b.func_175656_a(topPos, Blocks.field_150355_j.func_176223_P());
                        }
                        for (EnumFacing facing : EnumFacing.field_176754_o) {
                            if (!nextEntry.getValue()[facing.func_176736_b()].booleanValue()) continue;
                            BlockPos addingPos = nextPos.func_177972_a(facing);
                            if (this.nextCheckEntries.containsKey(addingPos)) {
                                Boolean[] existingArray = this.nextCheckEntries.get(addingPos);
                                existingArray[facing.func_176734_d().func_176736_b()] = false;
                                continue;
                            }
                            Boolean[] newArray = new Boolean[EnumFacing.field_176754_o.length];
                            for (int i = 0; i < newArray.length; ++i) {
                                newArray[i] = true;
                            }
                            newArray[facing.func_176734_d().func_176736_b()] = false;
                            this.nextCheckEntries.put(addingPos, newArray);
                        }
                    }
                } else {
                    for (int modX = -1; modX < 2; ++modX) {
                        for (int modY = -1; modY < 2; ++modY) {
                            for (int modZ = -1; modZ < 2; ++modZ) {
                                this.field_145850_b.func_175698_g(this.field_174879_c.func_177982_a(modX, modY, modZ));
                            }
                        }
                    }
                    Explosion explosion = new Explosion(this.field_145850_b, null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 4.0f, true, true);
                    explosion.func_77278_a();
                    explosion.func_77279_a(true);
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.FLAME, (double)this.field_174879_c.func_177958_n() + 0.2 + Math.random() * 0.6, (double)(this.field_174879_c.func_177956_o() - 1), (double)this.field_174879_c.func_177952_p() + 0.2 + Math.random() * 0.6, 0.0, -(Math.random() * 0.2), 0.0, new int[0]);
                }
            }
        } else if (this.state == STATE.STARTING) {
            this.startingCounter = Math.min(400, this.startingCounter + 1);
            if (!this.field_145850_b.field_72995_K) {
                if (!this.toBreak.isEmpty() && this.startingCounter % 4 == 0) {
                    BlockPos nextBreak = this.toBreak.remove(this.toBreak.size() - 1);
                    if (!this.field_145850_b.func_175623_d(nextBreak)) {
                        this.field_145850_b.func_175698_g(nextBreak);
                        this.field_145850_b.func_184133_a((EntityPlayer)null, nextBreak, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                        this.field_145850_b.func_175718_b(2000, nextBreak, 4);
                    }
                } else if (this.startingCounter == 400) {
                    this.run();
                }
            }
        }
    }

    public void start() {
        if (this.state == STATE.IDLE) {
            this.state = STATE.STARTING;
            this.startingCounter = 0;
            this.toBreak = new ArrayList<BlockPos>();
            for (int modX = -2; modX <= 2; ++modX) {
                for (int modZ = -2; modZ <= 2; ++modZ) {
                    for (int modY = -2; modY <= 2; ++modY) {
                        if (Math.abs(modX) != 2 && Math.abs(modZ) != 2 && Math.abs(modY) != 2) continue;
                        this.toBreak.add(this.field_174879_c.func_177982_a(modX, modY, modZ));
                    }
                }
            }
            Collections.shuffle(this.toBreak);
            this.syncTE();
        }
    }

    private void run() {
        this.state = STATE.RUNNING;
        this.nextCheckEntries = new LinkedHashMap();
        Boolean[] newArray = new Boolean[EnumFacing.field_176754_o.length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = true;
        }
        this.nextCheckEntries.put(this.field_174879_c, newArray);
        this.transformCount = 0L;
        this.syncTE();
    }

    public STATE getState() {
        return this.state;
    }

    public int getStartingCounter() {
        return this.startingCounter;
    }

    public static enum STATE {
        IDLE,
        STARTING,
        RUNNING;

    }
}

