/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.logic;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import reborncore.common.logic.LogicController;

public class LogicBlock
extends BlockContainer {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    @Nonnull
    LogicController logicController;

    public LogicBlock(LogicController logicController) {
        super(Material.field_151573_f);
        this.logicController = logicController;
        this.func_149663_c(logicController.getName());
        this.logicController.initBlock(this);
        this.func_149711_c(logicController.getHardness());
        if (logicController.hasRotation()) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        if (this.logicController != null) {
            return this.logicController.createNewTileEntity(worldIn, meta);
        }
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.logicController.onBlockActivated(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        this.logicController.addInformation(stack, world, tooltip, advanced.func_194127_a());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        if (this.logicController != null) {
            this.logicController.getRenderType(state);
        }
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.logicController != null) {
            return this.logicController.getBoundingBox(state, source, pos);
        }
        return super.func_185496_a(state, source, pos);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.logicController.onBlockAdded(worldIn, pos, state);
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.logicController.onBlockPlacedBy(worldIn, pos, state, placer, stack);
        if (this.logicController.hasRotation()) {
            this.setFacing(placer.func_174811_aO().func_176734_d(), worldIn, pos);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (this.dropInv()) {
            this.dropInventory(worldIn, pos);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean dropInv() {
        return this.logicController.dropInv();
    }

    protected void dropInventory(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return;
        }
        ItemStackHandler inventory = (ItemStackHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        this.addItemsToList((IItemHandler)inventory, items);
        for (ItemStack itemStack : items) {
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + dX), (double)((float)pos.func_177956_o() + dY), (double)((float)pos.func_177952_p() + dZ), itemStack.func_77946_l());
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.func_190920_e(0);
        }
    }

    private void addItemsToList(IItemHandler inventory, List<ItemStack> items) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemStack = inventory.getStackInSlot(i);
            if (!itemStack.func_190926_b() && itemStack.func_190916_E() > 0 && itemStack.func_77973_b() instanceof ItemBlock && (((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockFluidBase || ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockStaticLiquid || ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockDynamicLiquid)) continue;
            items.add(itemStack.func_77946_l());
        }
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        ACTIVE = PropertyBool.func_177716_a((String)"active");
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        if (this.logicController.hasRotation()) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
        }
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        int activeInt = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 0 : 4;
        return facingInt + activeInt;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        return 0;
    }
}

