/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.multiblock.rectangular;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerBase {
    protected RectangularMultiblockControllerBase(World world) {
        super(world);
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
            for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o(); ++y) {
                for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                    RectangularMultiblockTileEntityBase part;
                    TileEntity te = this.worldObj.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(String.format("Part @ %d, %d, %d is incompatible with machines of type %s", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.func_177956_o()) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.func_177956_o()) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }
}

