/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import sonar.core.api.inventories.ISonarInventory;
import sonar.core.handlers.inventories.SonarInventorySideWrapper;
import sonar.core.handlers.inventories.handling.EnumFilterType;
import sonar.core.handlers.inventories.handling.IInventoryWrapper;
import sonar.core.handlers.inventories.handling.filters.IExtractFilter;
import sonar.core.handlers.inventories.handling.filters.IInsertFilter;
import sonar.core.handlers.inventories.handling.filters.SlotHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.ISyncableListener;

public class SonarInventory
extends ItemStackHandler
implements ISonarInventory,
ISyncPart {
    private NonNullList<IItemHandlerModifiable> sided_handlers = SonarInventorySideWrapper.initWrappers(this);
    private Map<IInsertFilter, EnumFilterType> insert_filters = new HashMap<IInsertFilter, EnumFilterType>();
    private Map<IExtractFilter, EnumFilterType> extract_filters = new HashMap<IExtractFilter, EnumFilterType>();
    public boolean default_external_insert_result = false;
    public boolean default_external_extract_result = false;
    public boolean default_internal_insert_result = true;
    public boolean default_internal_extract_result = true;
    protected IInventory wrapped_inv = null;
    private int[] defaultSlots = null;
    public int slotLimit = 64;
    protected ISyncableListener listener;

    public SonarInventory(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Override
    public IInventory getWrapperInventory() {
        return this.wrapped_inv == null ? (this.wrapped_inv = new IInventoryWrapper(this)) : this.wrapped_inv;
    }

    @Override
    public IItemHandlerModifiable getItemHandler(EnumFacing side) {
        return SonarInventorySideWrapper.getHandlerForSide(this.sided_handlers, side);
    }

    @Override
    public int[] getDefaultSlots() {
        if (this.defaultSlots == null) {
            this.defaultSlots = new int[this.getSlots()];
            for (int i = 0; i < this.defaultSlots.length; ++i) {
                this.defaultSlots[i] = i;
            }
        }
        return this.defaultSlots;
    }

    public List<ItemStack> slots() {
        return this.stacks;
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    @Override
    public Map<IInsertFilter, EnumFilterType> getInsertFilters() {
        return this.insert_filters;
    }

    @Override
    public Map<IExtractFilter, EnumFilterType> getExtractFilters() {
        return this.extract_filters;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.canSync(type)) {
            this.stacks = NonNullList.func_191197_a((int)this.getSlots(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.stacks);
        }
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (this.canSync(type)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.stacks);
        }
        return nbt;
    }

    @Override
    public boolean checkInsert(int slot, @Nonnull ItemStack stack, @Nullable EnumFacing face, EnumFilterType internal) {
        boolean insert = internal.matches(EnumFilterType.INTERNAL) ? this.default_internal_insert_result : this.default_external_insert_result;
        return SlotHelper.checkInsert(slot, stack, face, internal, this, insert);
    }

    @Override
    public boolean checkExtract(int slot, int count, @Nullable EnumFacing face, EnumFilterType internal) {
        boolean extract = internal.matches(EnumFilterType.INTERNAL) ? this.default_internal_extract_result : this.default_external_extract_result;
        return SlotHelper.checkExtract(slot, count, face, internal, this, extract);
    }

    @Override
    public boolean checkDrop(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> toDrop = new ArrayList<ItemStack>();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack drop = (ItemStack)this.stacks.get(i);
            if (drop.func_190926_b() || !this.checkDrop(i, drop)) continue;
            toDrop.add(drop);
        }
        return toDrop;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.checkInsert(slot, stack, null, EnumFilterType.INTERNAL)) {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.checkExtract(slot, amount, null, EnumFilterType.INTERNAL)) {
            return super.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public IDirtyPart setListener(ISyncableListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public ISyncableListener getListener() {
        return this.listener;
    }

    public void markChanged() {
        if (this.listener != null) {
            this.listener.markChanged(this);
        }
    }

    @Override
    public String getTagName() {
        return "Items";
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(this.getSyncTypes());
    }

    public NBTHelper.SyncType[] getSyncTypes() {
        return new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE};
    }
}

