/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.block.Door;
import net.malisis.doors.iconprovider.SaloonDoorIconProvider;
import net.malisis.doors.renderer.SaloonDoorRenderer;
import net.malisis.doors.tileentity.SaloonDoorTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(value=SaloonDoorRenderer.class)
public class SaloonDoorBlock
extends Door {
    public SaloonDoorBlock(DoorDescriptor desc) {
        super(desc);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return new SaloonDoorIconProvider(this.descriptor);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        SaloonDoorTileEntity te = (SaloonDoorTileEntity)SaloonDoorBlock.getDoor((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        if (te.getDescriptor() == null) {
            return;
        }
        if (te.isMoving()) {
            return;
        }
        te.setOpenDirection(entity);
        if (world.field_72995_K) {
            return;
        }
        te.openOrCloseDoor();
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        if (SaloonDoorBlock.isTop(state)) {
            return null;
        }
        return new SaloonDoorTileEntity();
    }
}

