/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.movement;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.animation.transformation.Translation;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.doors.DoorState;
import net.malisis.doors.movement.IDoorMovement;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.minecraft.util.math.AxisAlignedBB;

public class Sliding4WaysMovement
implements IDoorMovement {
    @Override
    public AxisAlignedBB getOpenBoundingBox(DoorTileEntity tileEntity, boolean topBlock, BoundingBoxType type) {
        if (!tileEntity.isOpened()) {
            return IDoorMovement.getFullBoundingBox(topBlock, type);
        }
        if (type == BoundingBoxType.COLLISION && !topBlock) {
            return null;
        }
        AxisAlignedBB aabb = IDoorMovement.getHalfBoundingBox();
        float x = 0.0f;
        float y = 0.0f;
        if (topBlock != tileEntity.isHingeLeft()) {
            x = topBlock ? -0.8125f : 0.8125f;
        } else {
            float f = y = topBlock ? 0.8125f : -0.8125f;
        }
        if (tileEntity.isOpened()) {
            aabb = aabb.func_72317_d((double)x, (double)y, 0.0);
        }
        return aabb;
    }

    private Translation getTransformation(DoorTileEntity tileEntity, boolean topBlock) {
        float dir = -0.8125f;
        float toX = 0.0f;
        float toY = 0.0f;
        if (tileEntity.isHingeLeft()) {
            dir = -dir;
        }
        if (topBlock == tileEntity.isHingeLeft()) {
            toY = dir;
        } else {
            toX = dir;
        }
        Translation translation = new Translation(toX, toY, 0.0f);
        translation.reversed(tileEntity.getState() == DoorState.CLOSING || tileEntity.getState() == DoorState.CLOSED);
        translation.forTicks(tileEntity.getDescriptor().getOpeningTime());
        return translation;
    }

    @Override
    public Animation<?>[] getAnimations(DoorTileEntity tileEntity, MalisisModel model, RenderParameters rp) {
        return new Animation[]{new Animation((ITransformable)model.getShape("top"), (Transformation)this.getTransformation(tileEntity, true)), new Animation((ITransformable)model.getShape("bottom"), (Transformation)this.getTransformation(tileEntity, false))};
    }

    @Override
    public boolean isSpecial() {
        return false;
    }
}

