/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common;

import java.io.PrintStream;
import org.apache.logging.log4j.Logger;

public class TracingPrintStream
extends PrintStream {
    private Logger logger;
    private int BASE_DEPTH = 3;

    public TracingPrintStream(Logger logger, PrintStream original) {
        super(original);
        this.logger = logger;
    }

    @Override
    public void println(Object o) {
        this.logger.info("{}{}", (Object)this.getPrefix(), o);
    }

    @Override
    public void println(String s) {
        this.logger.info("{}{}", (Object)this.getPrefix(), (Object)s);
    }

    private String getPrefix() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        StackTraceElement elem = elems[this.BASE_DEPTH];
        if (elem.getClassName().startsWith("kotlin.io.")) {
            elem = elems[this.BASE_DEPTH + 2];
        } else if (elem.getClassName().startsWith("java.lang.Throwable")) {
            elem = elems[this.BASE_DEPTH + 4];
        }
        return "[" + elem.getClassName() + ":" + elem.getMethodName() + ":" + elem.getLineNumber() + "]: ";
    }
}

