/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.discordcraft;

import club.minnced.discord.rpc.DiscordEventHandlers;
import club.minnced.discord.rpc.DiscordRPC;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import me.dierke9.discordcraft.commands.DimInfo;
import me.dierke9.discordcraft.events.MainEventHandler;
import me.dierke9.discordcraft.presence.Presence;
import me.dierke9.discordcraft.templates.PresenceDimension;
import me.dierke9.discordcraft.templates.TemplateManager;
import me.dierke9.discordcraft.util.JsonConverter;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

@Mod(modid="discordcraft", version="1.0", name="Discordcraft", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class MinecraftRichPresence {
    public static final String MODID = "discordcraft";
    public static final String VERSION = "1.0";
    public static final String NAME = "Discordcraft";
    public static Presence presence;
    private MainEventHandler eventHandler;
    public static boolean modEnabled;
    public static TemplateManager templateManager;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        File discordcraftDir;
        File json;
        logger = event.getModLog();
        if (Config.discordApplicationID == null || Config.discordApplicationID.isEmpty() || Config.largeImageKey == null || Config.largeImageKey.isEmpty()) {
            logger.warn("Config incorrect using default values");
            Config.discordApplicationID = "529029853471834113";
            Config.largeImageKey = "defaultimage";
        }
        if (!(json = new File(discordcraftDir = new File(event.getModConfigurationDirectory(), MODID), "templates.json")).exists()) {
            try {
                json.createNewFile();
                FileWriter jsonOutput = new FileWriter(json);
                InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("assets/discordcraft/default.json"), "UTF-8");
                IOUtils.copy((Reader)reader, (Writer)jsonOutput);
                reader.close();
                jsonOutput.flush();
                jsonOutput.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (Config.templateFile == null || Config.templateFile.equalsIgnoreCase("")) {
            templateManager = JsonConverter.readFile("templates.json");
        } else {
            if (Config.templateFile.endsWith(".json")) {
                templateManager = JsonConverter.readFile(Config.templateFile);
            }
            if (!templateManager.hasGroup("default")) {
                throw new IllegalArgumentException("A default group template has to be defined");
            }
        }
        Map<String, PresenceDimension> map = templateManager.getDimensionList();
        for (Map.Entry<String, PresenceDimension> entry : map.entrySet()) {
            logger.info(entry.getKey() + ": " + entry.getValue().toString());
        }
        logger.info("Preinit of minecraft Rich Presence");
        presence = new Presence();
        DiscordRPC lib = null;
        try {
            lib = DiscordRPC.INSTANCE;
            DiscordEventHandlers handlers = new DiscordEventHandlers();
            handlers.ready = user -> System.out.println("Ready!");
            lib.Discord_Initialize(Config.discordApplicationID, handlers, true, "");
            Runtime.getRuntime().addShutdownHook(new Thread(lib::Discord_Shutdown));
            modEnabled = true;
        }
        catch (Throwable e) {
            logger.error("Error in initialization of Discord Rich Prsence", e);
            modEnabled = false;
        }
        presence.setState("Starting up");
        presence.updatePresence();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Initializing Minecraft Rich Presence");
        this.eventHandler = new MainEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
        this.eventHandler.createDimManager();
    }

    @Mod.EventHandler
    public void onLoad(FMLLoadCompleteEvent e) {
        presence.setState("Main menu");
        presence.updatePresence();
        presence.setCurrentId(-99999);
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new DimInfo());
    }

    static {
        modEnabled = false;
    }

    @net.minecraftforge.common.config.Config(modid="discordcraft", name="discordcraft/config")
    public static class Config {
        @Config.RequiresMcRestart
        @Config.Comment(value={"The applicationId of the Discord Rich presence"})
        public static String discordApplicationID = "529029853471834113";
        @Config.RequiresMcRestart
        @Config.Comment(value={"Big image used in the Rich Presence"})
        public static String largeImageKey = "defaultimage";
        @Config.RequiresMcRestart
        @Config.Comment(value={"Small circular image that will be used in the rich presence (optional)"})
        public static String smallImageKey = "minecrafticon";
        @Config.RequiresMcRestart
        @Config.Comment(value={"The name that should be displayed when hovering over the large image"})
        public static String modPackName = "";
        @Config.RequiresMcRestart
        @Config.Comment(value={"Set to true if you want to display the ip of the server you are currently connected to"})
        public static boolean showIp = true;
        @Config.RequiresMcRestart
        @Config.Comment(value={"File that gets used to load in the templates for the groups and dimensions", "!!! Be sure to add this file to the discordcraft config directory to work !!!"})
        public static String templateFile = "";
    }
}

