/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.discordcraft.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import me.dierke9.discordcraft.MinecraftRichPresence;
import me.dierke9.discordcraft.templates.PresenceDimension;
import me.dierke9.discordcraft.templates.PresenceDimensionGroup;
import me.dierke9.discordcraft.templates.TemplateManager;
import net.minecraftforge.fml.common.Loader;

public class JsonConverter {
    public static TemplateManager readFile(String fileName) {
        TemplateManager manager = new TemplateManager();
        JsonParser parser = new JsonParser();
        try {
            File file = new File(new File(Loader.instance().getConfigDir(), "discordcraft"), fileName);
            Gson gson = new Gson();
            JsonReader reader = new JsonReader((Reader)new FileReader(file));
            JsonObject elem = parser.parse(reader).getAsJsonObject();
            Set entrySet = elem.entrySet();
            for (Map.Entry entry : entrySet) {
                boolean group = ((String)entry.getKey()).equalsIgnoreCase("groups");
                boolean dim = ((String)entry.getKey()).equalsIgnoreCase("dimensions");
                if (!group && !dim || !((JsonElement)entry.getValue()).isJsonArray()) continue;
                JsonArray array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (JsonElement iterElem : array) {
                    if (group) {
                        manager.addGroup((PresenceDimensionGroup)gson.fromJson(iterElem, PresenceDimensionGroup.class));
                        continue;
                    }
                    manager.addDimension((PresenceDimension)gson.fromJson(iterElem, PresenceDimension.class));
                }
            }
        }
        catch (Exception e) {
            MinecraftRichPresence.logger.error("Error in parsing the json", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return manager;
    }
}

