/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.block.BlockTeleposer;
import WayofTime.bloodmagic.command.sub.SubCommandTeleposer;
import WayofTime.bloodmagic.core.data.Binding;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.event.TeleposeEvent;
import WayofTime.bloodmagic.item.ItemTelepositionFocus;
import WayofTime.bloodmagic.teleport.TeleportQueue;
import WayofTime.bloodmagic.teleport.Teleports;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileTeleposer
extends TileInventory
implements ITickable {
    public static final String TELEPOSER_RANGE = "teleposerRange";
    private int previousInput;

    public TileTeleposer() {
        super(1, "teleposer");
    }

    @Override
    public void deserialize(NBTTagCompound tagCompound) {
        super.deserialize(tagCompound);
        this.previousInput = tagCompound.func_74762_e("previousInput");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tagCompound) {
        super.serialize(tagCompound);
        tagCompound.func_74768_a("previousInput", this.previousInput);
        return tagCompound;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.canInitiateTeleport()) {
            int currentInput = this.func_145831_w().func_175676_y(this.field_174879_c);
            if (this.previousInput == 0 && currentInput != 0) {
                this.initiateTeleport();
            }
            this.previousInput = currentInput;
            if (this.field_145850_b.func_82737_E() % 100L == 0L) {
                ItemStack focusStack = this.func_70301_a(0);
                if (!focusStack.func_190926_b()) {
                    if (((ItemTelepositionFocus)focusStack.func_77973_b()).getBinding(focusStack) != null) {
                        SubCommandTeleposer.teleposerSet.add(this);
                    } else {
                        SubCommandTeleposer.teleposerSet.remove((Object)this);
                    }
                } else {
                    SubCommandTeleposer.teleposerSet.remove((Object)this);
                }
            }
        }
    }

    public void initiateTeleport() {
        block12: {
            UUID bindingOwnerID;
            List focusWorldEntities;
            List originalWorldEntities;
            World focusWorld;
            BlockPos focusPos;
            block13: {
                if (this.func_145831_w().field_72995_K || !this.canInitiateTeleport() || !(this.func_145838_q() instanceof BlockTeleposer)) break block12;
                ItemStack focusStack = this.func_70301_a(0);
                ItemTelepositionFocus focus = (ItemTelepositionFocus)focusStack.func_77973_b();
                Binding binding = focus.getBinding(focusStack);
                if (binding == null) {
                    return;
                }
                focusPos = focus.getBlockPos(focusStack);
                focusWorld = focus.getWorld(focusStack);
                if (focusWorld == null) {
                    return;
                }
                TileEntity boundTile = focusWorld.func_175625_s(focusPos);
                if (!(boundTile instanceof TileTeleposer) || boundTile == this) break block12;
                int focusLevel = focusStack.func_77952_i() + 1;
                int lpToBeDrained = (int)(0.5 * Math.sqrt((this.field_174879_c.func_177958_n() - focusPos.func_177958_n()) * (this.field_174879_c.func_177958_n() - focusPos.func_177958_n()) + (this.field_174879_c.func_177956_o() - focusPos.func_177956_o() + 1) * (this.field_174879_c.func_177956_o() - focusPos.func_177956_o() + 1) + (this.field_174879_c.func_177952_p() - focusPos.func_177952_p()) * (this.field_174879_c.func_177952_p() - focusPos.func_177952_p())));
                if (!NetworkHelper.syphonFromContainer(focusStack, SoulTicket.block(this.field_145850_b, this.field_174879_c, lpToBeDrained * (focusLevel * 2 - 1) * (focusLevel * 2 - 1) * (focusLevel * 2 - 1)))) break block12;
                int blocksTransported = 0;
                for (int i = -(focusLevel - 1); i <= focusLevel - 1; ++i) {
                    for (int j = 0; j <= focusLevel * 2 - 2; ++j) {
                        for (int k = -(focusLevel - 1); k <= focusLevel - 1; ++k) {
                            TeleposeEvent event = new TeleposeEvent(this.func_145831_w(), this.field_174879_c.func_177982_a(i, 1 + j, k), focusWorld, focusPos.func_177982_a(i, 1 + j, k));
                            if (MinecraftForge.EVENT_BUS.post((Event)event) || !Utils.swapLocations(event.initalWorld, event.initialBlockPos, event.finalWorld, event.finalBlockPos)) continue;
                            ++blocksTransported;
                        }
                    }
                }
                NetworkHelper.syphonFromContainer(focusStack, SoulTicket.item(focusStack, this.field_145850_b, this.field_174879_c, lpToBeDrained * blocksTransported));
                AxisAlignedBB originalArea = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)Math.min(focusWorld.func_72800_K(), this.field_174879_c.func_177956_o() + 2 * focusLevel), (double)(this.field_174879_c.func_177952_p() + 1)).func_72321_a((double)(focusLevel - 1), 0.0, (double)(focusLevel - 1));
                originalWorldEntities = this.func_145831_w().func_72872_a(Entity.class, originalArea);
                AxisAlignedBB focusArea = new AxisAlignedBB((double)focusPos.func_177958_n(), (double)(focusPos.func_177956_o() + 1), (double)focusPos.func_177952_p(), (double)(focusPos.func_177958_n() + 1), (double)Math.min(focusWorld.func_72800_K(), focusPos.func_177956_o() + 2 * focusLevel), (double)(focusPos.func_177952_p() + 1)).func_72321_a((double)(focusLevel - 1), 0.0, (double)(focusLevel - 1));
                focusWorldEntities = focusWorld.func_72872_a(Entity.class, focusArea);
                bindingOwnerID = binding.getOwnerId();
                if (!focusWorld.equals(this.func_145831_w())) break block13;
                if (!originalWorldEntities.isEmpty()) {
                    for (Entity entity : originalWorldEntities) {
                        TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(new BlockPos(entity.field_70165_t - (double)this.field_174879_c.func_177958_n() + (double)focusPos.func_177958_n(), entity.field_70163_u - (double)this.field_174879_c.func_177956_o() + (double)focusPos.func_177956_o(), entity.field_70161_v - (double)this.field_174879_c.func_177952_p() + (double)focusPos.func_177952_p()), entity, bindingOwnerID, true));
                    }
                }
                if (focusWorldEntities.isEmpty()) break block12;
                for (Entity entity : focusWorldEntities) {
                    TeleportQueue.getInstance().addITeleport(new Teleports.TeleportSameDim(new BlockPos(entity.field_70165_t - (double)focusPos.func_177958_n() + (double)this.field_174879_c.func_177958_n(), entity.field_70163_u - (double)focusPos.func_177956_o() + (double)this.field_174879_c.func_177956_o(), entity.field_70161_v - (double)focusPos.func_177952_p() + (double)this.field_174879_c.func_177952_p()), entity, bindingOwnerID, true));
                }
                break block12;
            }
            if (!originalWorldEntities.isEmpty()) {
                for (Entity entity : originalWorldEntities) {
                    TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(new BlockPos(entity.field_70165_t - (double)this.field_174879_c.func_177958_n() + (double)focusPos.func_177958_n(), entity.field_70163_u - (double)this.field_174879_c.func_177956_o() + (double)focusPos.func_177956_o(), entity.field_70161_v - (double)this.field_174879_c.func_177952_p() + (double)focusPos.func_177952_p()), entity, bindingOwnerID, this.func_145831_w(), focusWorld.field_73011_w.getDimension(), true));
                }
            }
            if (!focusWorldEntities.isEmpty()) {
                for (Entity entity : focusWorldEntities) {
                    TeleportQueue.getInstance().addITeleport(new Teleports.TeleportToDim(new BlockPos(entity.field_70165_t - (double)focusPos.func_177958_n() + (double)this.field_174879_c.func_177958_n(), entity.field_70163_u - (double)focusPos.func_177956_o() + (double)this.field_174879_c.func_177956_o(), entity.field_70161_v - (double)focusPos.func_177952_p() + (double)this.field_174879_c.func_177952_p()), entity, bindingOwnerID, focusWorld, this.func_145831_w().field_73011_w.getDimension(), true));
                }
            }
        }
    }

    private boolean canInitiateTeleport() {
        ItemStack focusStack = this.func_70301_a(0);
        return !focusStack.func_190926_b() && focusStack.func_77973_b() instanceof ItemTelepositionFocus && ((ItemTelepositionFocus)focusStack.func_77973_b()).getBinding(focusStack) != null;
    }
}

