/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.module;

import dan200.computercraft.api.lua.LuaException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.ISubTargetedMethod;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.ModuleContainerMethod;

public abstract class SubtargetedModuleMethod<T>
extends ModuleContainerMethod
implements ISubTargetedMethod<IModuleContainer, T> {
    private final Class<T> klass;

    public SubtargetedModuleMethod(String name, Set<ResourceLocation> modules, Class<T> klass, String docs) {
        this(name, modules, klass, 0, docs);
    }

    public SubtargetedModuleMethod(String name, Set<ResourceLocation> modules, Class<T> klass, int priority, String docs) {
        super(name, modules, priority, docs);
        this.klass = klass;
    }

    public static <T> SubtargetedModuleMethod<T> of(final String id, String name, ResourceLocation module, Class<T> klass, String docs, final IMethod.Delegate<IModuleContainer> delegate) {
        return new SubtargetedModuleMethod<T>(name, Collections.singleton(module), klass, docs){

            @Override
            @Nonnull
            public MethodResult apply(@Nonnull IUnbakedContext<IModuleContainer> context, @Nonnull Object[] args) throws LuaException {
                return delegate.apply(context, args);
            }

            @Override
            @Nonnull
            public String getId() {
                return id;
            }
        };
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<IModuleContainer> context) {
        if (!super.canApply(context)) {
            return false;
        }
        if (context.hasContext("origin", this.klass)) {
            return true;
        }
        for (ResourceLocation module : this.getModules()) {
            if (!context.hasContext(module.toString(), this.klass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public Class<T> getSubTarget() {
        return this.klass;
    }
}

