/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.squiddev.plethora.gameplay.client.RenderOverlay;
import org.squiddev.plethora.gameplay.registry.BasicMessage;

public final class ChatMessage
implements BasicMessage {
    public static final int TIME = 30;
    private int world;
    private Vec3d pos;
    private String message;
    private int count = 30;
    private int id;

    public ChatMessage(Entity entity, ITextComponent message) {
        this(entity.func_130014_f_().field_73011_w.getDimension(), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), message);
    }

    public ChatMessage(int world, Vec3d pos, ITextComponent message) {
        this.setup(world, pos, message.func_150254_d());
    }

    public ChatMessage() {
    }

    private void setup(int world, Vec3d pos, String message) {
        this.world = world;
        this.pos = pos;
        this.message = message;
        this.id = pos.hashCode() * 31 + message.hashCode();
    }

    public boolean decrement() {
        return --this.count <= 0;
    }

    public int getWorld() {
        return this.world;
    }

    public Vec3d getPosition() {
        return this.pos;
    }

    public String getMessage() {
        return this.message;
    }

    public int getId() {
        return this.id;
    }

    public int getCount() {
        return this.count;
    }

    public void fromBytes(ByteBuf buf) {
        this.setup(buf.readInt(), new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble()), ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.world);
        buf.writeDouble(this.pos.field_72450_a);
        buf.writeDouble(this.pos.field_72448_b);
        buf.writeDouble(this.pos.field_72449_c);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.message);
    }

    @Override
    public void onMessage(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            RenderOverlay.addMessage(this);
        }
    }
}

