/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.ArgumentHelper;
import java.util.Set;
import javax.annotation.Nonnull;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.PlethoraAPI;
import org.squiddev.plethora.api.method.BasicMethod;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.IMethodCollection;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.ITransferMethod;
import org.squiddev.plethora.api.method.IUnbakedContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.MethodResult;

@Injects
public final class MethodTransferLocations
extends BasicMethod<IMethodCollection> {
    public MethodTransferLocations() {
        super("getTransferLocations", "function([location:string]):table -- Get a list of all available objects which can be transferred to or from");
    }

    @Override
    public boolean canApply(@Nonnull IPartialContext<IMethodCollection> context) {
        return context.getTarget().has(ITransferMethod.class);
    }

    @Override
    @Nonnull
    public MethodResult apply(@Nonnull IUnbakedContext<IMethodCollection> context, @Nonnull Object[] args) throws LuaException {
        String location = ArgumentHelper.optString((Object[])args, (int)0, null);
        return MethodResult.nextTick(() -> {
            Set<String> locations;
            IContext baked = context.bake();
            if (location == null) {
                locations = baked.getTransferLocations();
            } else {
                Object found = baked.getTransferLocation(location);
                if (found == null) {
                    throw new LuaException("Location '" + location + "' does not exist");
                }
                locations = PlethoraAPI.instance().transferRegistry().getTransferLocations(found, false);
            }
            return MethodResult.result(new LuaList<String>(locations).asMap());
        });
    }
}

