/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.forestry;

import dan200.computercraft.api.lua.LuaException;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Map;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.integration.forestry.MetaGenome;

public final class MethodsAnalyzer {
    private MethodsAnalyzer() {
    }

    @PlethoraMethod(module={"forestry:analyzer"}, worldThread=false, modId="forestry", doc="-- Get a list of all species roots")
    public static Map<Integer, String> getSpeciesRoots() {
        return new LuaList(AlleleManager.alleleRegistry.getSpeciesRoot().keySet()).asMap();
    }

    private static ISpeciesRoot getSpeciesRoot(String uid) throws LuaException {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(uid);
        if (root == null) {
            throw new LuaException("Species root " + uid + " does not exist");
        }
        return root;
    }

    @PlethoraMethod(module={"forestry:analyzer"}, worldThread=false, modId="forestry", doc="-- Get a list of all species in the given species root")
    public static Map<Integer, Object> getSpeciesList(String root) throws LuaException {
        return AlleleManager.alleleRegistry.getRegisteredAlleles(MethodsAnalyzer.getSpeciesRoot(root).getSpeciesChromosomeType()).stream().map(IAlleleSpecies.class::cast).filter(s -> !s.isSecret()).map(MetaGenome::getAlleleMeta).collect(LuaList.toLuaList()).asMap();
    }

    @PlethoraMethod(module={"forestry:analyzer"}, worldThread=false, modId="forestry", doc="-- Get a list of all mutations in the given species root")
    public static Map<Integer, ? extends TypedMeta<? extends IMutation, ?>> getMutationsList(IContext<IModuleContainer> context, String root) throws LuaException {
        return MethodsAnalyzer.getSpeciesRoot(root).getMutations(false).stream().filter(s -> !s.isSecret()).map(m -> context.makePartialChild(m).getMeta()).collect(LuaList.toLuaList()).asMap();
    }
}

