/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla;

import com.mojang.authlib.GameProfile;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.utils.EquipmentInvWrapper;

public final class FakePlayerProviderEntity {
    private static final WeakHashMap<Entity, PlethoraFakePlayer> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderEntity() {
    }

    public static PlethoraFakePlayer getPlayer(Entity entity, IPlayerOwnable ownable) {
        return FakePlayerProviderEntity.getPlayer(entity, ownable == null ? null : ownable.getOwningProfile());
    }

    public static PlethoraFakePlayer getPlayer(Entity entity, GameProfile profile) {
        PlethoraFakePlayer fake = registeredPlayers.get(entity);
        if (fake == null) {
            fake = new PlethoraFakePlayer((WorldServer)entity.func_130014_f_(), entity, profile);
            registeredPlayers.put(entity, fake);
        }
        return fake;
    }

    public static void load(PlethoraFakePlayer player, Entity entity) {
        player.func_70029_a(entity.func_130014_f_());
        player.func_70080_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        player.field_70759_as = player.field_70177_z;
        player.func_70105_a(entity.field_70130_N, entity.field_70131_O);
        player.eyeHeight = entity.field_70131_O;
        player.func_70095_a(entity.func_70093_af());
        player.field_71071_by.field_70461_c = 0;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack stack = living.func_184582_a(slot);
                if (!stack.func_190926_b()) {
                    player.func_184201_a(slot, stack.func_77946_l());
                    player.func_110140_aT().func_111147_b(stack.func_111283_C(slot));
                    continue;
                }
                player.func_184201_a(slot, ItemStack.field_190927_a);
            }
        }
        player.field_71071_by.func_70296_d();
    }

    public static void unload(PlethoraFakePlayer player, EntityLivingBase entity) {
        player.field_71071_by.field_70461_c = 0;
        player.func_70105_a(0.0f, 0.0f);
        player.eyeHeight = player.getDefaultEyeHeight();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = player.func_184582_a(slot);
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)entity.func_184582_a(slot))) {
                entity.func_184201_a(slot, stack);
            }
            if (stack.func_190926_b()) continue;
            player.func_110140_aT().func_111148_a(stack.func_111283_C(slot));
        }
        NonNullList main = player.field_71071_by.field_70462_a;
        EquipmentInvWrapper handler = new EquipmentInvWrapper(entity);
        for (int i = 1; i < main.size(); ++i) {
            ItemStack stack = (ItemStack)main.get(i);
            for (int j = 0; j < 5 && !stack.func_190926_b(); ++j) {
                stack = handler.insertItem(j, stack, false);
            }
            if (!stack.func_190926_b()) {
                player.func_146097_a(stack, true, false);
            }
            main.set(i, (Object)ItemStack.field_190927_a);
        }
        player.field_71071_by.func_70296_d();
    }
}

