/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;

public final class MethodsDaylightSensor {
    private MethodsDaylightSensor() {
    }

    @PlethoraMethod(module={"minecraft:daylight_detector"}, worldThread=false, doc="-- Whether this world has a sky.")
    public static boolean hasSky(@FromContext(value={"origin"}) IWorldLocation location) {
        return location.getWorld().field_73011_w.func_191066_m();
    }

    @PlethoraMethod(module={"minecraft:daylight_detector"}, doc="-- The light level from the sun.")
    public static int getSkyLight(@FromContext(value={"origin"}) IWorldLocation location) throws LuaException {
        World world = location.getWorld();
        if (!world.field_73011_w.func_191066_m()) {
            throw new LuaException("The world has no sky");
        }
        BlockPos pos = location.getPos();
        return world.func_175642_b(EnumSkyBlock.SKY, pos) - world.func_175657_ab();
    }

    @PlethoraMethod(module={"minecraft:daylight_detector"}, doc="-- The light level from surrounding blocks.")
    public static int getBlockLight(@FromContext(value={"origin"}) IWorldLocation location) {
        return location.getWorld().func_175642_b(EnumSkyBlock.BLOCK, location.getPos());
    }

    @PlethoraMethod(module={"minecraft:daylight_detector"}, doc="-- The weather in the current world.")
    public static String getWeather(@FromContext(value={"origin"}) IWorldLocation location) {
        World world = location.getWorld();
        if (world.func_72896_J()) {
            return world.func_72911_I() ? "thunder" : "rain";
        }
        return "clear";
    }
}

