/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.network.netty;

import com.builtbroken.jlib.data.vector.IPos3D;
import icbm.classic.ICBMClassic;
import icbm.classic.api.IWorldPosition;
import icbm.classic.lib.network.IPacket;
import icbm.classic.lib.network.netty.PacketEncoderDecoderHandler;
import icbm.classic.lib.network.netty.PacketInboundHandler;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketManager {
    public final String channel;
    protected EnumMap<Side, FMLEmbeddedChannel> channelEnumMap;

    public PacketManager(String channel) {
        this.channel = channel;
    }

    public SPacketUpdateTileEntity toMCPacket(IPacket packet) {
        Packet proxyPacket = this.channelEnumMap.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
        return null;
    }

    public void init() {
        this.channelEnumMap = NetworkRegistry.INSTANCE.newChannel(this.channel, new ChannelHandler[]{new PacketEncoderDecoderHandler(), new PacketInboundHandler()});
    }

    public void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            ICBMClassic.logger().error("Packet sent to player[" + player + "]");
        }
    }

    public void sendToAllInDimension(IPacket packet, int dimId) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimId);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            ICBMClassic.logger().error("Packet sent to dim[" + dimId + "]");
        }
    }

    public void sendToAllInDimension(IPacket packet, World world) {
        this.sendToAllInDimension(packet, world.field_73011_w.getDimension());
    }

    public void sendToAll(IPacket packet) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)packet);
        } else {
            ICBMClassic.logger().error("Packet sent to all");
        }
    }

    public void sendToAllAround(IPacket message, NetworkRegistry.TargetPoint point) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channelEnumMap.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channelEnumMap.get(Side.SERVER).writeAndFlush((Object)message);
        } else {
            ICBMClassic.logger().error("Packet sent to target point: " + point);
        }
    }

    public void sendToAllAround(IPacket message, IWorldPosition point, double range) {
        this.sendToAllAround(message, point.world(), point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(IPacket message, World world, IPos3D point, double range) {
        this.sendToAllAround(message, world, point.x(), point.y(), point.z(), range);
    }

    public void sendToAllAround(IPacket message, TileEntity tile) {
        this.sendToAllAround(message, tile, 64.0);
    }

    public void sendToAllAround(IPacket message, TileEntity tile, double range) {
        this.sendToAllAround(message, tile.func_145831_w(), tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p(), range);
    }

    public void sendToAllAround(IPacket message, World world, double x, double y, double z, double range) {
        if (world != null) {
            this.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, range));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer(IPacket packet) {
        if (this.channelEnumMap != null) {
            this.channelEnumMap.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channelEnumMap.get(Side.CLIENT).writeAndFlush((Object)packet);
        } else {
            ICBMClassic.logger().error("Packet sent to server");
        }
    }
}

