/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.GuiCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTemperature;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.ContainerPlasticMixer;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.PlasticMixerRegistry;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPlasticMixer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiPlasticMixer
extends GuiPneumaticContainerBase<TileEntityPlasticMixer> {
    private GuiButtonSpecial[] buttons;
    private GuiCheckBox lockSelection;
    private WidgetLabel noItemsLabel;
    private WidgetLabel amountLabel;
    private WidgetTemperature tempWidget;
    private int nExposedFaces;
    private GuiAnimatedStat selectionTab;
    private Fluid lastFluid;
    private ItemStack lastItemStack = ItemStack.field_190927_a;

    public GuiPlasticMixer(InventoryPlayer player, TileEntityPlasticMixer te) {
        super(new ContainerPlasticMixer(player, te), te, "pneumaticcraft:textures/gui/gui_plastic_mixer.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addWidget(new WidgetTemperature(0, this.field_147003_i + 55, this.field_147009_r + 25, 273, 773, ((TileEntityPlasticMixer)this.te).getLogic(0), new int[0]));
        this.tempWidget = new WidgetTemperature(1, this.field_147003_i + 82, this.field_147009_r + 25, 273, 773, ((TileEntityPlasticMixer)this.te).getLogic(1), new int[]{273}){

            @Override
            public void addTooltip(int mouseX, int mouseY, List<String> curTip, boolean shift) {
                super.addTooltip(mouseX, mouseY, curTip, shift);
                if (this.getScales().length >= 2) {
                    TextFormatting tf = this.getScales()[1] <= ((TileEntityPlasticMixer)GuiPlasticMixer.this.te).getLogic(1).getTemperatureAsInt() ? TextFormatting.GREEN : TextFormatting.GOLD;
                    curTip.add(tf + "Required Temperature: " + (this.getScales()[1] - 273) + "\u00b0C");
                }
            }
        };
        this.addWidget(this.tempWidget);
        this.addWidget(new WidgetTank(3, this.field_147003_i + 152, this.field_147009_r + 14, ((TileEntityPlasticMixer)this.te).getTank()));
        PlasticMixerRegistry.PlasticMixerRecipe recipe = PlasticMixerRegistry.INSTANCE.getRecipe(((TileEntityPlasticMixer)this.te).getTank().getFluid());
        Item targetItem = recipe == null ? Itemss.PLASTIC : recipe.getItemStack().func_77973_b();
        this.selectionTab = this.addAnimatedStat("gui.tab.plasticMixer.plasticSelection", new ItemStack(targetItem, 1, 1), -16755456, false);
        this.selectionTab.addPadding(12, 88 / this.field_146289_q.func_78256_a(" "));
        this.buttons = new GuiButtonSpecial[16];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int index = y * 4 + x;
                ItemStack stack = new ItemStack(targetItem, 1, index);
                this.buttons[index] = new GuiButtonSpecial(index + 1, x * 21 + 15, y * 21 + 30, 20, 20, "").setRenderStacks(stack).setTooltipText(stack.func_82833_r());
                this.selectionTab.addWidget(this.buttons[index]);
            }
        }
        this.noItemsLabel = new WidgetLabel(15, 34, TextFormatting.GOLD.toString() + TextFormatting.ITALIC + I18n.func_135052_a((String)"gui.tab.plasticMixer.tankEmpty", (Object[])new Object[0]));
        this.selectionTab.addWidget(this.noItemsLabel);
        this.amountLabel = new WidgetLabel(15, 118, "");
        this.selectionTab.addWidget(this.amountLabel);
        this.lockSelection = new GuiCheckBox(17, 15, 18, -16777216, "gui.plasticMixer.lockSelection").setChecked(((TileEntityPlasticMixer)this.te).lockSelection).setTooltip(PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.plasticMixer.lockSelection.tooltip", (Object[])new Object[0])));
        this.selectionTab.addWidget(this.lockSelection);
        if (((TileEntityPlasticMixer)this.te).getTank().getFluid() != null && ((TileEntityPlasticMixer)this.te).getTank().getFluid().amount > 0) {
            this.selectionTab.openWindow();
        }
        this.updateSelectionTab();
        this.nExposedFaces = HeatUtil.countExposedFaces(Collections.singletonList(this.te));
    }

    private void updateSelectionTab() {
        PlasticMixerRegistry.PlasticMixerRecipe recipe = PlasticMixerRegistry.INSTANCE.getRecipe(((TileEntityPlasticMixer)this.te).getTank().getFluid());
        boolean recipeOK = recipe != null && recipe.allowSolidifying();
        int nTypes = recipe == null ? 0 : recipe.getNumSubTypes();
        for (int index = 0; index < 16; ++index) {
            if (recipeOK) {
                ItemStack stack = new ItemStack(recipe.getItemStack().func_77973_b(), 1, index);
                this.buttons[index].setRenderStacks(stack).setTooltipText(stack.func_82833_r());
            }
            this.buttons[index].setVisible(recipeOK && index < nTypes);
            this.buttons[index].field_146125_m = recipeOK && index < nTypes;
        }
        if (recipeOK) {
            FluidStack f = recipe.getFluidStack();
            this.amountLabel.text = StringUtils.abbreviate((String)(TextFormatting.GRAY + "" + f.amount + "mB " + f.getFluid().getLocalizedName(f)), (int)20);
        }
        this.amountLabel.visible = recipeOK;
        this.noItemsLabel.visible = !recipeOK;
        this.selectionTab.setTexture(recipeOK ? recipe.getItemStack() : new ItemStack(Blocks.field_189881_dj));
    }

    @Override
    public void func_73876_c() {
        Fluid f;
        super.func_73876_c();
        if (this.selectionTab != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].field_146124_l = ((TileEntityPlasticMixer)this.te).selectedPlastic != i;
            }
            this.lockSelection.checked = ((TileEntityPlasticMixer)this.te).lockSelection;
        }
        if ((f = this.getFluid()) != this.lastFluid) {
            this.updateSelectionTab();
        }
        this.lastFluid = this.getFluid();
        ItemStack input = ((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(0);
        if (!ItemStack.func_179545_c((ItemStack)input, (ItemStack)this.lastItemStack)) {
            PlasticMixerRegistry.PlasticMixerRecipe recipe = PlasticMixerRegistry.INSTANCE.getRecipe(input);
            if (recipe != null && recipe.allowMelting()) {
                this.tempWidget.setScales(273, recipe.getTemperature());
            } else {
                this.tempWidget.setScales(273);
            }
        }
        this.lastItemStack = ((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(1).func_77946_l();
    }

    private Fluid getFluid() {
        return ((TileEntityPlasticMixer)this.te).getTank().getFluid() == null ? null : ((TileEntityPlasticMixer)this.te).getTank().getFluid().getFluid();
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.field_146289_q.func_78276_b("Upgr.", 15, 19, 0x404040);
        this.field_146289_q.func_78276_b("Hull", 56, 16, 0x404040);
        this.field_146289_q.func_78276_b("Item", 88, 16, 0x404040);
    }

    @Override
    protected void func_146976_a(float partialTicks, int x, int y) {
        super.func_146976_a(partialTicks, x, y);
        for (int i = 0; i < 3; ++i) {
            double percentage = (double)((TileEntityPlasticMixer)this.te).dyeBuffers[i] / 8160.0;
            this.func_73728_b(this.field_147003_i + 124, this.field_147009_r + 35 + i * 18, this.field_147009_r + 37 - MathHelper.func_76125_a((int)((int)(percentage * 16.0)), (int)1, (int)15) + i * 18, 0xFF000000 | 0xFF0000 >> 8 * i);
        }
    }

    @Override
    protected Point getInvNameOffset() {
        return new Point(0, -1);
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    @Override
    protected void addProblems(List<String> curInfo) {
        super.addProblems(curInfo);
        ItemStack stack = ((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(0);
        if (((TileEntityPlasticMixer)this.te).getTank().getFluidAmount() == 0) {
            if (stack.func_190926_b()) {
                curInfo.add("gui.tab.problems.plasticMixer.noPlastic");
            } else {
                curInfo.add("gui.tab.problems.notEnoughHeat");
            }
        } else if (!stack.func_190926_b()) {
            int amount;
            PlasticMixerRegistry.PlasticMixerRecipe recipe = PlasticMixerRegistry.INSTANCE.getRecipe(stack);
            int temp = recipe == null ? 423 : recipe.getTemperature();
            int n = amount = recipe == null ? 1000 : recipe.getFluidStack().amount;
            if (((TileEntityPlasticMixer)this.te).getLogic(1).getTemperatureAsInt() >= temp && ((TileEntityPlasticMixer)this.te).getTank().getCapacity() - ((TileEntityPlasticMixer)this.te).getTank().getFluidAmount() < amount) {
                curInfo.add("gui.tab.problems.plasticMixer.plasticOverflow");
            }
        }
        if (((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(2).func_190926_b()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.plasticMixer.noDye", (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 1).func_82833_r()}));
        }
        if (((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(3).func_190926_b()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.plasticMixer.noDye", (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 2).func_82833_r()}));
        }
        if (((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(4).func_190926_b()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.plasticMixer.noDye", (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 4).func_82833_r()}));
        }
    }

    @Override
    protected void addInformation(List<String> curInfo) {
        if (curInfo.size() == 0) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.plasticMixer.noProblems", (Object[])new Object[0]));
        }
    }

    @Override
    protected void addWarnings(List<String> curInfo) {
        super.addWarnings(curInfo);
        if (this.nExposedFaces > 0 && !((TileEntityPlasticMixer)this.te).getPrimaryInventory().getStackInSlot(0).func_190926_b()) {
            curInfo.add(I18n.func_135052_a((String)"gui.tab.problems.exposedFaces", (Object[])new Object[]{this.nExposedFaces, 6}));
        }
    }
}

