/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.block;

import java.util.List;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HackableMobSpawner
implements IHackableBlock {
    @Override
    public String getId() {
        return "mobSpawner";
    }

    @Override
    public boolean canHack(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return !HackableMobSpawner.isHacked(world, pos);
    }

    public static boolean isHacked(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityMobSpawner && ((TileEntityMobSpawner)te).func_145881_a().field_98289_l == 0;
    }

    @Override
    public void addInfo(World world, BlockPos pos, List<String> curInfo, EntityPlayer player) {
        curInfo.add("pneumaticHelmet.hacking.result.neutralize");
    }

    @Override
    public void addPostHackInfo(World world, BlockPos pos, List<String> curInfo, EntityPlayer player) {
        curInfo.add("pneumaticHelmet.hacking.finished.neutralized");
    }

    @Override
    public int getHackTime(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return 200;
    }

    @Override
    public void onHackFinished(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            TileEntity te = world.func_175625_s(pos);
            if (te != null) {
                te.func_189515_b(tag);
                tag.func_74777_a("RequiredPlayerRange", (short)0);
                te.func_145839_a(tag);
                IBlockState state = world.func_180495_p(pos);
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    @Override
    public boolean afterHackTick(World world, BlockPos pos) {
        MobSpawnerBaseLogic spawner = ((TileEntityMobSpawner)world.func_175625_s(pos)).func_145881_a();
        spawner.field_98284_d = spawner.field_98287_c;
        spawner.field_98286_b = 10;
        return false;
    }
}

