/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.config.MicromissileDefaults;
import me.desht.pneumaticcraft.common.entity.projectile.EntityMicromissile;
import me.desht.pneumaticcraft.common.item.ItemPneumatic;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMicromissiles
extends ItemPneumatic {
    public static final String NBT_TOP_SPEED = "topSpeed";
    public static final String NBT_TURN_SPEED = "turnSpeed";
    public static final String NBT_DAMAGE = "damage";
    public static final String NBT_FILTER = "filter";
    public static final String NBT_PX = "px";
    public static final String NBT_PY = "py";
    public static final String NBT_FIRE_MODE = "fireMode";

    public ItemMicromissiles() {
        super("micromissiles");
        this.func_77656_e(ConfigHandler.microMissile.missilePodSize - 1);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack iStack = playerIn.func_184586_b(handIn);
        if (playerIn.func_70093_af()) {
            playerIn.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.MICROMISSILE.ordinal(), worldIn, (int)playerIn.field_70165_t, (int)playerIn.field_70163_u, (int)playerIn.field_70161_v);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)iStack);
        }
        EntityMicromissile missile = new EntityMicromissile(worldIn, (EntityLivingBase)playerIn, iStack);
        Vec3d directionVec = playerIn.func_70040_Z().func_72432_b();
        missile.field_70165_t += directionVec.field_72450_a;
        missile.field_70163_u += directionVec.field_72448_b + 0.1;
        missile.field_70161_v += directionVec.field_72449_c;
        missile.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, this.getInitialVelocity(iStack), 0.0f);
        playerIn.func_184811_cZ().func_185145_a((Item)this, ConfigHandler.microMissile.launchCooldown);
        if (!worldIn.field_72995_K) {
            RayTraceResult res = PneumaticCraftUtils.getMouseOverServer((EntityLivingBase)playerIn, 100.0);
            if (res.field_72313_a == RayTraceResult.Type.ENTITY && missile.isValidTarget(res.field_72308_g)) {
                missile.setTarget(res.field_72308_g);
            }
            worldIn.func_72838_d((Entity)missile);
        }
        if (!playerIn.field_71075_bZ.field_75098_d) {
            iStack.func_77972_a(1, (EntityLivingBase)playerIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)iStack);
    }

    private float getInitialVelocity(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            FireMode fireMode = FireMode.fromString(tag.func_74779_i(NBT_FIRE_MODE));
            if (fireMode == FireMode.SMART) {
                return Math.max(0.2f, tag.func_74760_g(NBT_TOP_SPEED) / 2.0f);
            }
            return 0.33333334f;
        }
        return 0.33333334f;
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<String> curInfo, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, worldIn, curInfo, extraInfo);
        curInfo.add(I18n.func_135052_a((String)"gui.micromissile.remaining", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + (stack.func_77958_k() - stack.func_77952_i() + 1));
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            curInfo.add(" ");
            curInfo.add(" ");
            curInfo.add(" ");
            String filter = tag.func_74779_i(NBT_FILTER);
            if (!filter.isEmpty()) {
                curInfo.add(I18n.func_135052_a((String)"gui.sentryTurret.targetFilter", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + filter);
            }
            curInfo.add(I18n.func_135052_a((String)"gui.micromissile.firingMode", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + I18n.func_135052_a((String)("gui.micromissile.mode." + tag.func_74779_i(NBT_FIRE_MODE)), (Object[])new Object[0]));
            if (ConfigHandler.microMissile.damageTerrain) {
                curInfo.add(I18n.func_135052_a((String)"gui.tooltip.terrainWarning", (Object[])new Object[0]));
            } else {
                curInfo.add(I18n.func_135052_a((String)"gui.tooltip.terrainSafe", (Object[])new Object[0]));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        MicromissileDefaults.Entry def;
        if (!stack.func_77942_o() && entityIn instanceof EntityPlayer && (def = MicromissileDefaults.INSTANCE.getDefaults((EntityPlayer)entityIn)) != null) {
            stack.func_77982_d(def.toNBT());
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public static ItemStack getHeldMicroMissile(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == Itemss.MICROMISSILES) {
            return stack;
        }
        stack = player.func_184592_cb();
        if (stack.func_77973_b() == Itemss.MICROMISSILES) {
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static enum FireMode {
        SMART,
        DUMB;


        public static FireMode fromString(String mode) {
            try {
                return FireMode.valueOf(mode);
            }
            catch (IllegalArgumentException e) {
                return SMART;
            }
        }
    }
}

