/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import me.desht.pneumaticcraft.common.inventory.ContainerAmadron;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferCustom;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.server.permission.PermissionAPI;

public class PacketSyncAmadronOffers
extends AbstractPacket<PacketSyncAmadronOffers> {
    private Collection<AmadronOffer> staticOffers = new ArrayList<AmadronOffer>();
    private Collection<AmadronOffer> selectedPeriodicOffers = new ArrayList<AmadronOffer>();
    private boolean mayAddPeriodic;
    private boolean mayAddStatic;

    public PacketSyncAmadronOffers() {
    }

    public PacketSyncAmadronOffers(EntityPlayer playerIn) {
        this.staticOffers = AmadronOfferManager.getInstance().getStaticOffers();
        this.selectedPeriodicOffers = AmadronOfferManager.getInstance().getSelectedPeriodicOffers();
        this.mayAddPeriodic = PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"pneumaticcraft.amadron.addPeriodicTrade");
        this.mayAddStatic = PermissionAPI.hasPermission((EntityPlayer)playerIn, (String)"pneumaticcraft.amadron.addStaticTrade");
    }

    public static Object readFluidOrItemStack(ByteBuf buf) {
        if (buf.readByte() == 0) {
            return ByteBufUtils.readItemStack((ByteBuf)buf);
        }
        return new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf));
    }

    public static void writeFluidOrItemStack(Object object, ByteBuf buf) {
        if (object instanceof ItemStack) {
            buf.writeByte(0);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)object));
        } else {
            buf.writeByte(1);
            FluidStack stack = (FluidStack)object;
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)stack.getFluid().getName());
            buf.writeInt(stack.amount);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.staticOffers = this.readOffers(buf);
        this.selectedPeriodicOffers = this.readOffers(buf);
        this.mayAddPeriodic = buf.readBoolean();
        this.mayAddStatic = buf.readBoolean();
    }

    private Collection<AmadronOffer> readOffers(ByteBuf buf) {
        int offerCount = buf.readInt();
        ArrayList<AmadronOffer> offers = new ArrayList<AmadronOffer>();
        for (int i = 0; i < offerCount; ++i) {
            if (buf.readBoolean()) {
                offers.add(AmadronOfferCustom.loadFromBuf(buf));
                continue;
            }
            offers.add(new AmadronOffer(PacketSyncAmadronOffers.readFluidOrItemStack(buf), PacketSyncAmadronOffers.readFluidOrItemStack(buf)));
        }
        return offers;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.staticOffers.size());
        for (AmadronOffer offer : this.staticOffers) {
            buf.writeBoolean(offer instanceof AmadronOfferCustom);
            offer.writeToBuf(buf);
        }
        buf.writeInt(this.selectedPeriodicOffers.size());
        for (AmadronOffer offer : this.selectedPeriodicOffers) {
            buf.writeBoolean(offer instanceof AmadronOfferCustom);
            offer.writeToBuf(buf);
        }
        buf.writeBoolean(this.mayAddPeriodic);
        buf.writeBoolean(this.mayAddStatic);
    }

    @Override
    public void handleClientSide(PacketSyncAmadronOffers message, EntityPlayer player) {
        AmadronOfferManager.getInstance().syncOffers(message.staticOffers, message.selectedPeriodicOffers);
        ContainerAmadron.mayAddPeriodicOffers = message.mayAddPeriodic;
        ContainerAmadron.mayAddStaticOffers = message.mayAddStatic;
    }

    @Override
    public void handleServerSide(PacketSyncAmadronOffers message, EntityPlayer player) {
    }
}

