/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import vswe.superfactory.SuperFactoryManager;
import vswe.superfactory.tiles.TileEntityCluster;
import vswe.superfactory.tiles.TileEntityOutput;

public class BlockCableOutput
extends BlockContainer {
    public static final IUnlistedProperty<Integer> STRONG_SIDES = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"strong_sides", (int)0, (int)63));
    public static final IUnlistedProperty<Integer> WEAK_SIDES = new Properties.PropertyAdapter((IProperty)PropertyInteger.func_177719_a((String)"strong_sides", (int)0, (int)63));

    public BlockCableOutput() {
        super(Material.field_151573_f);
        this.func_149647_a(SuperFactoryManager.creativeTab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c("sfm.cable_output");
        this.func_149711_c(1.2f);
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityOutput();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, true);
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public int func_180656_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityOutput te = this.getTileEntity(blockAccess, pos);
        if (te != null) {
            return te.getStrengthFromOppositeSide(side);
        }
        return 0;
    }

    private TileEntityOutput getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TileEntityOutput)TileEntityCluster.getTileEntity(TileEntityOutput.class, world, pos);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntityOutput te = this.getTileEntity(blockAccess, pos);
        if (te != null && te.hasStrongSignalAtOppositeSide(side)) {
            return te.getStrengthFromOppositeSide(side);
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{STRONG_SIDES, WEAK_SIDES};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityOutput tileEntity = (TileEntityOutput)world.func_175625_s(pos);
        if (state instanceof IExtendedBlockState && tileEntity != null) {
            int strongVals = 0;
            int weakVals = 0;
            for (EnumFacing facing : EnumFacing.values()) {
                if (tileEntity.getStrengthFromSide(facing) <= 0) continue;
                if (tileEntity.hasStrongSignalAtSide(facing)) {
                    strongVals |= 1 << facing.func_176745_a();
                    continue;
                }
                weakVals |= 1 << facing.func_176745_a();
            }
            return ((IExtendedBlockState)state).withProperty(STRONG_SIDES, (Object)strongVals).withProperty(WEAK_SIDES, (Object)weakVals);
        }
        return state;
    }
}

