/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuTarget;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;

public class ComponentMenuTargetInventory
extends ComponentMenuTarget {
    private static final String NBT_END = "EndRange";
    private static final String NBT_START = "StartRange";
    private int[] endRange = new int[directions.length];
    private TextBoxNumber endTextBox;
    private int[] startRange = new int[directions.length];
    private TextBoxNumber startTextBox;
    private TextBoxNumberList textBoxes = new TextBoxNumberList();

    public ComponentMenuTargetInventory(FlowComponent parent) {
        super(parent);
        this.startTextBox = new TextBoxNumber(39, 49, 2, false){

            @Override
            public void onNumberChanged() {
                if (ComponentMenuTargetInventory.this.selectedDirectionId != -1 && ComponentMenuTargetInventory.this.getParent().getManager().func_145831_w().field_72995_K) {
                    ComponentMenuTargetInventory.this.writeData(ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA, this.getNumber());
                }
            }
        };
        this.textBoxes.addTextBox(this.startTextBox);
        this.endTextBox = new TextBoxNumber(60, 49, 2, false){

            @Override
            public void onNumberChanged() {
                if (ComponentMenuTargetInventory.this.selectedDirectionId != -1 && ComponentMenuTargetInventory.this.getParent().getManager().func_145831_w().field_72995_K) {
                    ComponentMenuTargetInventory.this.writeData(ComponentMenuTarget.DataTypeHeader.END, this.getNumber());
                }
            }
        };
        this.textBoxes.addTextBox(this.endTextBox);
    }

    @Override
    protected ComponentMenuTarget.Button getSecondButton() {
        return new ComponentMenuTarget.Button(27){

            @Override
            protected String getLabel() {
                return ComponentMenuTargetInventory.this.useAdvancedSetting(ComponentMenuTargetInventory.this.selectedDirectionId) ? Localization.ALL_SLOTS.toString() : Localization.ID_RANGE.toString();
            }

            @Override
            protected String getMouseOverText() {
                return ComponentMenuTargetInventory.this.useAdvancedSetting(ComponentMenuTargetInventory.this.selectedDirectionId) ? Localization.ALL_SLOTS_LONG.toString() : Localization.ID_RANGE_LONG.toString();
            }

            @Override
            protected void onClicked() {
                ComponentMenuTargetInventory.this.writeData(ComponentMenuTarget.DataTypeHeader.USE_ADVANCED_SETTING, ComponentMenuTargetInventory.this.useAdvancedSetting(ComponentMenuTargetInventory.this.selectedDirectionId) ? 0 : 1);
            }
        };
    }

    @Override
    protected void writeAdvancedSetting(DataWriter dw, int i) {
        dw.writeData(this.startRange[i], DataBitHelper.MENU_TARGET_RANGE);
        dw.writeData(this.endRange[i], DataBitHelper.MENU_TARGET_RANGE);
    }

    @Override
    protected void readAdvancedSetting(DataReader dr, int i) {
        this.startRange[i] = dr.readData(DataBitHelper.MENU_TARGET_RANGE);
        this.endRange[i] = dr.readData(DataBitHelper.MENU_TARGET_RANGE);
    }

    @Override
    protected void resetAdvancedSetting(int i) {
        this.endRange[i] = 0;
        this.startRange[i] = 0;
    }

    @Override
    protected void copyAdvancedSetting(ComponentMenu menu, int i) {
        ComponentMenuTargetInventory menuTarget = (ComponentMenuTargetInventory)menu;
        this.startRange[i] = menuTarget.startRange[i];
        this.endRange[i] = menuTarget.endRange[i];
    }

    @Override
    protected void refreshAdvancedComponentData(ContainerManager container, ComponentMenu newData, int i) {
        ComponentMenuTargetInventory newDataTarget = (ComponentMenuTargetInventory)newData;
        if (this.startRange[i] != newDataTarget.startRange[i]) {
            this.startRange[i] = newDataTarget.startRange[i];
            this.writeUpdatedData(container, i, ComponentMenuTarget.DataTypeHeader.START_OR_TANK_DATA, this.startRange[i]);
        }
        if (this.endRange[i] != newDataTarget.endRange[i]) {
            this.endRange[i] = newDataTarget.endRange[i];
            this.writeUpdatedData(container, i, ComponentMenuTarget.DataTypeHeader.END, this.endRange[i]);
        }
    }

    @Override
    protected void loadAdvancedComponent(NBTTagCompound directionTag, int i) {
        this.startRange[i] = directionTag.func_74771_c(NBT_START);
        this.endRange[i] = directionTag.func_74771_c(NBT_END);
    }

    @Override
    protected void saveAdvancedComponent(NBTTagCompound directionTag, int i) {
        directionTag.func_74774_a(NBT_START, (byte)this.getStart(i));
        directionTag.func_74774_a(NBT_END, (byte)this.getEnd(i));
    }

    public int getStart(int i) {
        return this.startRange[i];
    }

    public int getEnd(int i) {
        return this.endRange[i];
    }

    @Override
    public void addErrors(List<String> errors) {
        for (int i = 0; i < directions.length; ++i) {
            if (!this.isActive(i) || this.getStart(i) <= this.getEnd(i)) continue;
            errors.add(Localization.getDirectionLocalization(EnumFacing.func_82600_a((int)i)).toString() + " " + Localization.INVALID_RANGE.toString());
        }
        super.addErrors(errors);
    }

    @Override
    protected void refreshAdvancedComponent() {
        if (this.selectedDirectionId != -1) {
            this.startTextBox.setNumber(this.startRange[this.selectedDirectionId]);
            this.endTextBox.setNumber(this.endRange[this.selectedDirectionId]);
        }
    }

    @Override
    protected void onAdvancedClick(int mX, int mY, int button) {
        this.textBoxes.onClick(mX, mY, button);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawAdvancedComponent(GuiManager gui, int mX, int mY) {
        this.textBoxes.draw(gui, mX, mY);
    }

    @Override
    protected void readAdvancedNetworkComponent(DataReader dr, ComponentMenuTarget.DataTypeHeader header, int i) {
        int data = dr.readData(header.getBits());
        switch (header) {
            case START_OR_TANK_DATA: {
                this.startRange[i] = data;
                this.refreshAdvancedComponent();
                break;
            }
            case END: {
                this.endRange[i] = data;
                this.refreshAdvancedComponent();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (this.selectedDirectionId != -1 && this.useAdvancedSetting(this.selectedDirectionId)) {
            return this.textBoxes.onKeyStroke(gui, c, k);
        }
        return false;
    }
}

