/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Quat4f;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraftforge.common.model.TRSRTransformation;
import openmods.block.BlockRotationMode;
import openmods.geometry.Orientation;
import org.apache.commons.io.IOUtils;
import org.lwjgl.util.vector.Matrix4f;

public class OrientationInfoGenerator {
    private static final File OUTPUT_DIR = new File(new File("etc"), "orientations");
    private static Pattern namePattern = Pattern.compile("X(\\d+)_Y(\\d+)");

    private static List<XYZRotation> sorted(Collection<XYZRotation> l) {
        ArrayList tmp = Lists.newArrayList(l);
        Collections.sort(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpBlockRotationsRotations(BlockRotationMode brm, Multimap<Orientation, ModelRotation> vanilla, Multimap<Orientation, XYZRotation> xyz) throws IOException {
        File outFile = new File(OUTPUT_DIR, brm.name().toLowerCase(Locale.ROOT) + ".txt");
        System.out.println("Generating file: " + outFile.getAbsolutePath());
        PrintWriter out = null;
        try {
            out = new PrintWriter(outFile);
            for (Orientation o : Sets.newTreeSet(brm.getValidDirections())) {
                StringBuilder line = new StringBuilder();
                line.append('\"');
                line.append(o.func_176610_l().toLowerCase(Locale.ROOT));
                line.append("\": {");
                Collection v = vanilla.get((Object)o);
                if (!v.isEmpty()) {
                    ModelRotation m = (ModelRotation)v.iterator().next();
                    line.append(OrientationInfoGenerator.modelRotationToJson(m));
                } else {
                    XYZRotation f = OrientationInfoGenerator.sorted(xyz.get((Object)o)).iterator().next();
                    line.append(OrientationInfoGenerator.forgeRotationToJson(f));
                }
                line.append("}, // front: ");
                line.append(brm.getFront(o));
                line.append(", top: ");
                line.append(brm.getTop(o));
                out.println(line.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    private static String forgeRotationToJson(XYZRotation f) {
        ArrayList result = Lists.newArrayList();
        if (f.z != Rotation.R0) {
            result.add("{\"z\": " + f.z.toString() + "}");
        }
        if (f.y != Rotation.R0) {
            result.add("{\"y\": " + f.y.toString() + "}");
        }
        if (f.x != Rotation.R0) {
            result.add("{\"x\": " + f.x.toString() + "}");
        }
        return "{ \"transform\": { \"rotation\": [" + Joiner.on((String)", ").join((Iterable)result) + "]}}";
    }

    private static String modelRotationToJson(ModelRotation m) {
        Matcher matcher = namePattern.matcher(m.name());
        Preconditions.checkState((boolean)matcher.matches());
        String x = matcher.group(1);
        String y = matcher.group(2);
        ArrayList result = Lists.newArrayList();
        if (!x.equals("0")) {
            result.add("\"x\": " + x);
        }
        if (!y.equals("0")) {
            result.add("\"y\": " + y);
        }
        return Joiner.on((String)", ").join((Iterable)result);
    }

    private static Multimap<Orientation, XYZRotation> calculateXyzRotations(Map<Matrix3f, Orientation> fromMatrix) {
        HashMultimap toXYZRotation = HashMultimap.create();
        for (Rotation x : Rotation.values()) {
            for (Rotation y : Rotation.values()) {
                for (Rotation z : Rotation.values()) {
                    XYZRotation rotation = new XYZRotation(x, y, z);
                    Quat4f q = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
                    Quat4f tmp = new Quat4f();
                    tmp.set(new AxisAngle4f(0.0f, 0.0f, 1.0f, z.angle));
                    q.mul(tmp);
                    tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, y.angle));
                    q.mul(tmp);
                    tmp.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, x.angle));
                    q.mul(tmp);
                    Matrix3f m = new Matrix3f();
                    m.set(q);
                    OrientationInfoGenerator.roundMatrixElements(m);
                    Orientation orientation = fromMatrix.get(m);
                    Preconditions.checkNotNull((Object)((Object)orientation), (Object)rotation);
                    toXYZRotation.put((Object)orientation, (Object)rotation);
                }
            }
        }
        return toXYZRotation;
    }

    private static void roundMatrixElements(Matrix3f m) {
        m.m00 = Math.round(m.m00);
        m.m01 = Math.round(m.m01);
        m.m02 = Math.round(m.m02);
        m.m10 = Math.round(m.m10);
        m.m11 = Math.round(m.m11);
        m.m12 = Math.round(m.m12);
        m.m20 = Math.round(m.m20);
        m.m21 = Math.round(m.m21);
        m.m22 = Math.round(m.m22);
    }

    private static Matrix3f roundAndReduceMatrixElements(javax.vecmath.Matrix4f m) {
        Preconditions.checkArgument((m.m30 == 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((m.m31 == 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((m.m32 == 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((m.m03 == 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((m.m13 == 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((m.m23 == 0.0f ? 1 : 0) != 0);
        Preconditions.checkArgument((m.m33 == 1.0f ? 1 : 0) != 0);
        Matrix3f result = new Matrix3f();
        result.m00 = Math.round(m.m00);
        result.m01 = Math.round(m.m01);
        result.m02 = Math.round(m.m02);
        result.m10 = Math.round(m.m10);
        result.m11 = Math.round(m.m11);
        result.m12 = Math.round(m.m12);
        result.m20 = Math.round(m.m20);
        result.m21 = Math.round(m.m21);
        result.m22 = Math.round(m.m22);
        return result;
    }

    private static Multimap<Orientation, ModelRotation> calculateVanillaRotations(Map<Matrix3f, Orientation> fromMatrix) {
        HashMultimap toVanilla = HashMultimap.create();
        for (ModelRotation rot : ModelRotation.values()) {
            javax.vecmath.Matrix4f rotMatrix = TRSRTransformation.toVecmath((Matrix4f)rot.func_177525_a());
            Matrix3f key = OrientationInfoGenerator.roundAndReduceMatrixElements(rotMatrix);
            Orientation orientation = fromMatrix.get(key);
            Preconditions.checkNotNull((Object)((Object)orientation), (Object)rot);
            toVanilla.put((Object)orientation, (Object)rot);
        }
        return toVanilla;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpOrientations(Multimap<Orientation, ModelRotation> vanilla, Multimap<Orientation, XYZRotation> xyz) throws IOException {
        File outFile = new File(OUTPUT_DIR, "all.txt");
        System.out.println("Generating file: " + outFile.getAbsolutePath());
        PrintWriter out = null;
        try {
            out = new PrintWriter(outFile);
            for (Orientation o : Orientation.VALUES) {
                out.println(String.format("%s = %s -> x=%s,y=%s,z=%s -> XY: %s, XYZ: %s", new Object[]{o.name(), o, o.x.dir, o.y.dir, o.z.dir, vanilla.get((Object)o), OrientationInfoGenerator.sorted(xyz.get((Object)o))}));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static void main(String[] args) throws IOException {
        OUTPUT_DIR.mkdirs();
        HashMap fromMatrix = Maps.newHashMap();
        for (Orientation o : Orientation.VALUES) {
            fromMatrix.put(o.getLocalToWorldMatrix(), o);
        }
        Multimap<Orientation, ModelRotation> vanilla = OrientationInfoGenerator.calculateVanillaRotations(fromMatrix);
        Multimap<Orientation, XYZRotation> xyz = OrientationInfoGenerator.calculateXyzRotations(fromMatrix);
        OrientationInfoGenerator.dumpOrientations(vanilla, xyz);
        for (BlockRotationMode brm : BlockRotationMode.values()) {
            OrientationInfoGenerator.dumpBlockRotationsRotations(brm, vanilla, xyz);
        }
    }

    private static class XYZRotation
    implements Comparable<XYZRotation> {
        public final Rotation x;
        public final Rotation y;
        public final Rotation z;

        public XYZRotation(Rotation x, Rotation y, Rotation z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private static int countComponent(Rotation r) {
            return r == Rotation.R0 ? 0 : 1;
        }

        private int componentCount() {
            return XYZRotation.countComponent(this.x) + XYZRotation.countComponent(this.y) + XYZRotation.countComponent(this.z);
        }

        private float angleSum() {
            return this.x.angle + this.y.angle + this.z.angle;
        }

        @Override
        public int compareTo(XYZRotation o) {
            int result = Ints.compare((int)this.componentCount(), (int)o.componentCount());
            if (result != 0) {
                return result;
            }
            return Floats.compare((float)this.angleSum(), (float)o.angleSum());
        }

        public String toString() {
            ArrayList r = Lists.newArrayList();
            if (this.x != Rotation.R0) {
                r.add("X" + (Object)((Object)this.x));
            }
            if (this.y != Rotation.R0) {
                r.add("Y" + (Object)((Object)this.y));
            }
            if (this.z != Rotation.R0) {
                r.add("Z" + (Object)((Object)this.z));
            }
            return Joiner.on((char)'_').join((Iterable)r);
        }
    }

    private static enum Rotation {
        R0(0),
        R90(90),
        R180(180),
        R270(270);

        public final String name;
        public final float angle;

        private Rotation(int angle) {
            this.angle = (float)Math.toRadians(angle);
            this.name = Integer.toString(angle);
        }

        public String toString() {
            return this.name;
        }
    }
}

