/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.network.rpc.targets.SyncRpcTarget;
import openmods.network.senders.IPacketSender;
import openmods.reflection.TypeUtils;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncMapProvider;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.sync.SyncMapClient;
import openmods.sync.SyncMapServer;
import openmods.sync.SyncMapTile;
import openmods.sync.SyncObjectScanner;
import openmods.sync.drops.DropTagSerializer;
import openmods.tileentity.OpenTileEntity;

public abstract class SyncedTileEntity
extends OpenTileEntity
implements ISyncMapProvider {
    private static final String TAG_SYNC_INIT = "SyncInit";
    private SyncMap syncMap;
    private DropTagSerializer tagSerializer;

    public SyncedTileEntity() {
        this.createSyncedFields();
    }

    private void createSyncMap(World world) {
        SyncMap syncMap = world.field_72995_K ? new SyncMapClient() : new SyncMapTile(this, SyncMapServer.UpdateStrategy.WITH_INITIAL_PACKET);
        SyncObjectScanner.INSTANCE.registerAllFields(syncMap, this);
        syncMap.addSyncListener(changes -> this.markUpdated());
        this.syncMap = syncMap;
        this.onSyncMapCreate(syncMap);
    }

    protected void onSyncMapCreate(SyncMap syncMap) {
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.createSyncMap(this.field_145850_b);
    }

    protected void func_190201_b(World worldIn) {
        this.createSyncMap(worldIn);
    }

    protected DropTagSerializer getDropSerializer() {
        if (this.tagSerializer == null) {
            this.tagSerializer = new DropTagSerializer();
        }
        return this.tagSerializer;
    }

    protected ISyncListener createRenderUpdateListener() {
        return changes -> this.markBlockForRenderUpdate(this.func_174877_v());
    }

    protected ISyncListener createRenderUpdateListener(ISyncableObject target) {
        return changes -> {
            if (changes.contains(target)) {
                this.markBlockForRenderUpdate(this.func_174877_v());
            }
        };
    }

    protected ISyncListener createRenderUpdateListener(Set<ISyncableObject> targets) {
        return changes -> {
            if (!Sets.intersection((Set)changes, (Set)targets).isEmpty()) {
                this.markBlockForRenderUpdate(this.func_174877_v());
            }
        };
    }

    protected void markBlockForRenderUpdate(BlockPos pos) {
        this.field_145850_b.func_175704_b(pos, pos);
    }

    protected abstract void createSyncedFields();

    public void sync() {
        this.getSyncMap().sendUpdates();
    }

    public boolean trySync() {
        return this.getSyncMap().trySendUpdates();
    }

    @Override
    public SyncMap getSyncMap() {
        Preconditions.checkState((this.syncMap != null ? 1 : 0) != 0, (Object)"Tile entity not initialized properly");
        return this.syncMap;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.getSyncMap().tryWrite(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.getSyncMap().tryRead(tag);
    }

    private NBTTagCompound serializeInitializationData(NBTTagCompound tag) {
        PacketBuffer tmp = new PacketBuffer(Unpooled.buffer());
        try {
            this.getSyncMap().writeInitializationData(tmp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] data = new byte[tmp.readableBytes()];
        tmp.readBytes(data);
        tag.func_74773_a(TAG_SYNC_INIT, data);
        return tag;
    }

    private void applyInitializationData(NBTTagCompound tag) {
        if (tag.func_150297_b(TAG_SYNC_INIT, 7)) {
            byte[] syncInit = tag.func_74770_j(TAG_SYNC_INIT);
            PacketBuffer tmp = new PacketBuffer(Unpooled.buffer());
            tmp.writeBytes(syncInit);
            try {
                this.getSyncMap().readIntializationData(tmp);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.serializeInitializationData(super.func_189517_E_());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.applyInitializationData(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 43, this.serializeInitializationData(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.applyInitializationData(pkt.func_148857_g());
    }

    public <T> T createRpcProxy(ISyncableObject object, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        TypeUtils.isInstance(object, mainIntf, extraIntf);
        SyncRpcTarget.SyncTileEntityRpcTarget target = new SyncRpcTarget.SyncTileEntityRpcTarget(this, object);
        IPacketSender sender = RpcCallDispatcher.instance().senders.client;
        return RpcCallDispatcher.instance().createProxy(target, sender, mainIntf, extraIntf);
    }
}

