/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

public class FloatUpdateTracker {
    int ticksSinceLastUpdate = 0;
    int ticksBetweenUpdates;
    int ticksBetweenUrgentUpdates;
    float value = 0.0f;
    float minimumDifference;
    float maximumDifference;

    public FloatUpdateTracker(int minimumTicksBetweenUpdates, int minimumTicksBetweenUrgentUpdates, float minimumSpreadForUpdate, float maximumSpreadForUpdate) {
        this.ticksBetweenUpdates = minimumTicksBetweenUpdates;
        this.ticksBetweenUrgentUpdates = Math.min(this.ticksBetweenUpdates, minimumTicksBetweenUrgentUpdates);
        this.minimumDifference = minimumSpreadForUpdate;
        this.maximumDifference = Math.max(this.minimumDifference, maximumSpreadForUpdate);
    }

    public void setValue(float v) {
        this.value = v;
        this.ticksSinceLastUpdate = 0;
    }

    public void onExternalUpdate() {
        this.ticksSinceLastUpdate = 0;
    }

    public boolean shouldUpdate(float currentValue) {
        ++this.ticksSinceLastUpdate;
        if (this.ticksSinceLastUpdate < this.ticksBetweenUrgentUpdates) {
            return false;
        }
        float spread = Math.abs(currentValue - this.value);
        if (spread >= this.maximumDifference) {
            this.ticksSinceLastUpdate = 0;
            this.value = currentValue;
            return true;
        }
        if (this.ticksSinceLastUpdate < this.ticksBetweenUpdates) {
            return false;
        }
        if (spread >= this.minimumDifference) {
            this.ticksSinceLastUpdate = 0;
            this.value = currentValue;
            return true;
        }
        this.ticksSinceLastUpdate = this.ticksBetweenUpdates;
        return false;
    }
}

