/*
 * Decompiled with CFR 0.152.
 */
package c4.conarm.common.armor.modifiers;

import c4.conarm.lib.modifiers.ArmorModifierTrait;
import c4.conarm.lib.utils.ConstructUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModSpeedy
extends ArmorModifierTrait {
    protected static final UUID[] SPEED_MODIFIERS = new UUID[]{UUID.fromString("857af40b-def8-47e3-a838-527933eca586"), UUID.fromString("1fd2c8fb-5a76-4e6f-bccd-c27f2287ad1b"), UUID.fromString("54e47051-19ac-4e59-9e54-4f256484408a"), UUID.fromString("ac16532f-d0b0-4b23-a89a-85ecaa3b5d7d")};
    protected int max;

    public ModSpeedy(int count) {
        super("speedy", 0x910000, 3, count);
        this.max = count;
    }

    public void getAttributeModifiers(@Nonnull EntityEquipmentSlot slot, ItemStack stack, Multimap<String, AttributeModifier> attributeMap) {
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            attributeMap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(SPEED_MODIFIERS[slot.func_188454_b()], "Speedy modifier", (double)this.getSpeedBonus(stack), 2));
        }
    }

    protected float getSpeedBonus(ItemStack stack) {
        NBTTagCompound modifierTag = new NBTTagCompound();
        NBTTagList tagList = TagUtil.getModifiersTagList((NBTTagCompound)TagUtil.getTagSafe((ItemStack)stack));
        int index = TinkerUtil.getIndexInList((NBTTagList)tagList, (String)this.identifier);
        if (index >= 0) {
            modifierTag = tagList.func_150305_b(index);
        }
        ModifierNBT.IntegerNBT modData = ModifierNBT.readInteger((NBTTagCompound)modifierTag);
        return this.getSpeedBonus(modData);
    }

    protected float getSpeedBonus(ModifierNBT.IntegerNBT modData) {
        return 0.05f * (float)modData.current / (float)this.max;
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        return this.getLeveledTooltip(modifierTag, detailed);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getIdentifier());
        ImmutableList.Builder builder = ImmutableList.builder();
        float bonus = this.getSpeedBonus(ModifierNBT.readInteger((NBTTagCompound)modifierTag));
        builder.add((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{ConstructUtils.dfPercentSpec.format(bonus)}));
        return builder.build();
    }
}

