/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.itemblacklist.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.doubledoordev.itemblacklist.Helper;
import net.doubledoordev.itemblacklist.data.BanList;
import net.doubledoordev.itemblacklist.data.BanListEntry;
import net.doubledoordev.itemblacklist.data.GlobalBanList;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.EntityNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandBlockItem
extends CommandBase {
    public static final CommandBlockItem I = new CommandBlockItem();

    private CommandBlockItem() {
    }

    public String func_71517_b() {
        return "blockitem";
    }

    public List<String> func_71514_a() {
        return Arrays.asList("itemblacklist", "blacklist");
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "Use '/blockitem help' for more info.";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            sender.func_145747_a(new TextComponentString("Possible subcommands:").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            sender.func_145747_a(this.makeHelpText("reload", "Reloads the config file from disk."));
            sender.func_145747_a(this.makeHelpText("pack [player]", "Lock banned items in targets inventory."));
            sender.func_145747_a(this.makeHelpText("unpack [player]", "Unlock banned items in targets inventory."));
            sender.func_145747_a(this.makeHelpText("list [dim|player]", "List banned items of all, player, or dim"));
            sender.func_145747_a(this.makeHelpText("ban [dim list] [item[:*|meta]]", "Ban an item."));
            sender.func_145747_a(this.makeHelpText("unban [dim list] [item[:*|meta]]", "Unban an item."));
            return;
        }
        String arg0 = args[0].toLowerCase();
        boolean unpack = false;
        switch (arg0) {
            default: {
                throw new WrongUsageException("Unknown subcommand. Use '/blockitem' to get some help.", new Object[0]);
            }
            case "reload": {
                GlobalBanList.init(server);
                sender.func_145747_a(new TextComponentString("Reloaded!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
            case "list": {
                this.list(server, sender, args);
                break;
            }
            case "unpack": {
                unpack = true;
            }
            case "pack": {
                EntityPlayerMP player = args.length > 1 ? CommandBlockItem.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]) : CommandBlockItem.func_71521_c((ICommandSender)sender);
                int count = GlobalBanList.process(player.field_71093_bK, (IInventory)player.field_71071_by, unpack);
                sender.func_145747_a((ITextComponent)new TextComponentString((unpack ? "Unlocked " : "Locked ") + count + " items."));
                break;
            }
            case "ban": {
                try {
                    Pair<String, BanListEntry> toBan = this.parse(sender, args);
                    GlobalBanList.worldInstance.add((String)toBan.k, (BanListEntry)toBan.v);
                    sender.func_145747_a(new TextComponentString("Banned " + ((BanListEntry)toBan.v).toString() + " in " + (String)toBan.k).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new WrongUsageException(e.getMessage(), new Object[0]);
                }
            }
            case "unban": {
                try {
                    Pair<String, BanListEntry> toBan = this.parse(sender, args);
                    if (GlobalBanList.worldInstance.remove((String)toBan.k, (BanListEntry)toBan.v)) {
                        sender.func_145747_a(new TextComponentString("Unbanned " + ((BanListEntry)toBan.v).toString() + " in " + (String)toBan.k).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                        break;
                    }
                    sender.func_145747_a(new TextComponentString("Can't unban " + ((BanListEntry)toBan.v).toString() + " in " + (String)toBan.k).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new WrongUsageException(e.getMessage(), new Object[0]);
                }
            }
        }
    }

    private Pair<String, BanListEntry> parse(ICommandSender sender, String[] args) throws PlayerNotFoundException, WrongUsageException {
        String dimensions = null;
        boolean wildcardOverride = false;
        int meta = Short.MAX_VALUE;
        BanListEntry banListEntry = null;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("__GLOBAL__")) {
                dimensions = "__GLOBAL__";
                continue;
            }
            try {
                Helper.parseDimIds(args[i]);
                if (dimensions != null) {
                    throw new WrongUsageException("Double dimension specifiers: " + dimensions + " AND " + args[i], new Object[0]);
                }
                dimensions = args[i];
                continue;
            }
            catch (Exception exception) {
                try {
                    String[] split = args[i].split(":");
                    if (split.length > 3) {
                        throw new WrongUsageException("Item name not valid.", new Object[0]);
                    }
                    int n = meta = split.length == 3 ? CommandBlockItem.func_175755_a((String)split[2]) : Short.MAX_VALUE;
                    if (banListEntry != null) {
                        throw new WrongUsageException("Double item specifiers: " + banListEntry + " AND " + args[i], new Object[0]);
                    }
                    banListEntry = new BanListEntry(split[0] + ":" + split[1], meta);
                    continue;
                }
                catch (Exception split) {
                    if (args[i].equals("*")) {
                        wildcardOverride = true;
                        continue;
                    }
                    throw new IllegalArgumentException("Not a dimension specifier or valid item: " + args[i]);
                }
            }
        }
        if (dimensions == null) {
            dimensions = String.valueOf(CommandBlockItem.func_71521_c((ICommandSender)sender).field_71093_bK);
        }
        if (banListEntry == null) {
            EntityPlayerMP player = CommandBlockItem.func_71521_c((ICommandSender)sender);
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (stack.func_190926_b()) {
                throw new WrongUsageException("No item specified and no item held.", new Object[0]);
            }
            if (wildcardOverride) {
                meta = Short.MAX_VALUE;
            }
            banListEntry = new BanListEntry(stack.func_77973_b().getRegistryName(), meta);
        }
        return new Pair<String, Object>(dimensions, banListEntry);
    }

    private void list(ICommandSender sender, HashSet<BanList> set) {
        for (BanList list : set) {
            sender.func_145747_a(new TextComponentString("Dimension " + list.getDimension()).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)));
            for (BanListEntry entry : list.banListEntryMap.values()) {
                sender.func_145747_a((ITextComponent)new TextComponentString(entry.toString()));
            }
        }
    }

    private void list(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        HashSet<BanList> packSet = new HashSet<BanList>();
        HashSet<BanList> worldSet = new HashSet<BanList>();
        if (args.length == 1) {
            worldSet.addAll(GlobalBanList.worldInstance.dimesionMap.values());
            worldSet.add(GlobalBanList.worldInstance.getGlobal());
            if (GlobalBanList.packInstance != null) {
                packSet.addAll(GlobalBanList.packInstance.dimesionMap.values());
                packSet.add(GlobalBanList.packInstance.getGlobal());
            }
        } else {
            if (args[1].equalsIgnoreCase("__GLOBAL__")) {
                worldSet.add(GlobalBanList.worldInstance.getGlobal());
            } else {
                worldSet.addAll(GlobalBanList.worldInstance.dimesionMap.get((Object)this.getDimension(server, sender, args[1])));
            }
            if (GlobalBanList.packInstance != null) {
                if (args[1].equalsIgnoreCase("__GLOBAL__")) {
                    packSet.add(GlobalBanList.packInstance.getGlobal());
                } else {
                    packSet.addAll(GlobalBanList.packInstance.dimesionMap.get((Object)this.getDimension(server, sender, args[1])));
                }
            }
        }
        if (worldSet.isEmpty()) {
            sender.func_145747_a(new TextComponentString("No world banned items.").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        } else {
            sender.func_145747_a(new TextComponentString("World banned items:").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            this.list(sender, worldSet);
        }
        if (packSet.isEmpty()) {
            sender.func_145747_a(new TextComponentString("No pack banned items. ").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150257_a(new TextComponentString("[unchangeable]").func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
        } else {
            sender.func_145747_a(new TextComponentString("Pack banned items: ").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)).func_150257_a(new TextComponentString("[unchangeable]").func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
            this.list(sender, packSet);
        }
    }

    private int getDimension(MinecraftServer server, ICommandSender sender, String arg) throws WrongUsageException {
        try {
            return Integer.parseInt(arg);
        }
        catch (Exception exception) {
            try {
                return CommandBlockItem.func_184885_b((MinecraftServer)server, (ICommandSender)sender, (String)arg).field_71093_bK;
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (CommandException e) {
                e.printStackTrace();
            }
            throw new WrongUsageException("%s is not an entity or a number", new Object[]{arg});
        }
    }

    public ITextComponent makeHelpText(String name, String text) {
        return new TextComponentString(name).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150257_a(new TextComponentString(": " + text).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (this.func_82358_a(args, args.length)) {
            return CommandBlockItem.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 1) {
            return CommandBlockItem.func_71530_a((String[])args, (String[])new String[]{"reload", "pack", "unpack", "list", "ban", "unban"});
        }
        if (args[0].equalsIgnoreCase("ban") || args[0].equalsIgnoreCase("unban")) {
            HashSet<String> set = new HashSet<String>();
            set.add("__GLOBAL__");
            for (ResourceLocation rl : Item.field_150901_e.func_148742_b()) {
                set.add(rl.toString());
            }
            return CommandBlockItem.func_175762_a((String[])args, set);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public boolean func_82358_a(String[] args, int arg) {
        if (args.length == 0) {
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "unpack": 
            case "pack": 
            case "list": {
                return arg == 2;
            }
        }
        return false;
    }

    public static class Pair<K, V> {
        public K k;
        public V v;

        public Pair(K k, V v) {
            this.k = k;
            this.v = v;
        }
    }
}

