/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.api.tile.ITileEffects;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockPanelController;
import galaxyspace.systems.SolarSystem.planets.overworld.blocks.machines.BlockSingleSolarPanel;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldProviderHell;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityPanelController
extends TileBaseUniversalElectricalSource
implements ITileEffects,
IDisableableMachine,
ISidedInventory,
IConnector {
    public static final float MIN_GENERATE_GJ_PER_TICK = 1.0f;
    public Map<BlockPos, Integer> panels = new HashMap<BlockPos, Integer>();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    private boolean visible = false;

    public TileEntityPanelController() {
        super("tile.panel_controller.name");
        this.storage.setCapacity(5000.0f);
        this.storage.setMaxExtract(2000.0f);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void func_73660_a() {
        int z;
        int x;
        if (this.heatGJperTick - 1.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 1.0f, false);
        }
        super.func_73660_a();
        this.panels.clear();
        int distance = 21;
        boolean modules = true;
        int xMin = 0;
        int xMax = 0;
        int zMin = 0;
        int zMax = 0;
        switch (this.getFront()) {
            case EAST: {
                BlockPos pos;
                xMin = 1;
                xMax = distance - 1;
                zMin = -2;
                zMax = 3;
                for (x = 0; x <= distance; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (x > distance - 1 || !(this.field_145850_b.func_180495_p(pos = new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z)).func_177230_c() instanceof BlockSingleSolarPanel) || !this.field_145850_b.func_175710_j(pos.func_177984_a())) continue;
                        this.panels.put(pos, ((BlockSingleSolarPanel)this.field_145850_b.func_180495_p(pos).func_177230_c()).getTier());
                    }
                }
                break;
            }
            case NORTH: {
                BlockPos pos;
                xMin = -2;
                xMax = 3;
                zMin = -distance + 1;
                zMax = 0;
                for (x = -2; x <= 2; ++x) {
                    for (z = zMin; z <= zMax - 1; ++z) {
                        if (z < zMin || !(this.field_145850_b.func_180495_p(pos = new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z)).func_177230_c() instanceof BlockSingleSolarPanel) || !this.field_145850_b.func_175710_j(pos.func_177984_a())) continue;
                        this.panels.put(pos, ((BlockSingleSolarPanel)this.field_145850_b.func_180495_p(pos).func_177230_c()).getTier());
                    }
                }
                break;
            }
            case SOUTH: {
                BlockPos pos;
                xMin = -2;
                xMax = 3;
                zMin = 1;
                zMax = distance - 1;
                for (x = -2; x <= 2; ++x) {
                    for (z = 0; z <= distance; ++z) {
                        if (z > distance - 1 || !(this.field_145850_b.func_180495_p(pos = new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z)).func_177230_c() instanceof BlockSingleSolarPanel) || !this.field_145850_b.func_175710_j(pos.func_177984_a())) continue;
                        this.panels.put(pos, ((BlockSingleSolarPanel)this.field_145850_b.func_180495_p(pos).func_177230_c()).getTier());
                    }
                }
                break;
            }
            case WEST: {
                BlockPos pos;
                xMin = -distance + 1;
                xMax = 0;
                zMin = -2;
                zMax = 3;
                for (x = -distance; x <= 0; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (x < -distance + 1 || !(this.field_145850_b.func_180495_p(pos = new BlockPos(this.func_174877_v().func_177958_n() + x, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p() + z)).func_177230_c() instanceof BlockSingleSolarPanel) || !this.field_145850_b.func_175710_j(pos.func_177984_a())) continue;
                        this.panels.put(pos, ((BlockSingleSolarPanel)this.field_145850_b.func_180495_p(pos).func_177230_c()).getTier());
                    }
                }
                break;
            }
        }
        if (this.field_145850_b.field_72995_K && this.visible) {
            for (x = xMin; x <= xMax; ++x) {
                for (z = zMin; z <= zMax; ++z) {
                    if (x != xMin && x != xMax && z != zMin && z != zMax) continue;
                    this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, (double)(this.func_174877_v().func_177958_n() + x), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() + z), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.produce();
            if (this.field_145850_b.func_72935_r() && (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider || !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I())) {
                float angle = this.field_145850_b.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
                float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
                float difference = (180.0f - Math.abs((celestialAngle %= 360.0f) % 180.0f - celestialAngle)) / 180.0f;
                int t2_count = 0;
                for (Map.Entry<BlockPos, Integer> panel : this.panels.entrySet()) {
                    if (panel.getValue() != 2) continue;
                    ++t2_count;
                }
                this.heatGJperTick = MathHelper.func_76141_d((float)((0.01f * difference * difference * (9.0f * (Math.abs(difference) * 500.0f)) * this.getSolarBoost() + (float)(1 * t2_count) * 0.5f) * ((float)this.panels.size() * GSConfigEnergy.coefficientSolarPanel) / 5.0f));
            } else {
                this.heatGJperTick = 0.0f;
            }
        }
    }

    public float getSolarBoost() {
        if (this.field_145850_b.field_73011_w instanceof WorldProviderHell) {
            return 0.0f;
        }
        return (float)(this.field_145850_b.field_73011_w instanceof ISolarLevel ? ((ISolarLevel)this.field_145850_b.field_73011_w).getSolarEnergyMultiplier() : 1.0);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1NBTTagCompound) {
        super.func_189515_b(par1NBTTagCompound);
        ItemStackHelper.func_191282_a((NBTTagCompound)par1NBTTagCompound, (NonNullList)this.getInventory());
        return par1NBTTagCompound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing direction) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public float receiveElectricity(EnumFacing from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public void setDisabled(int index, boolean disabled) {
    }

    public boolean getDisabled(int index) {
        return false;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getElectricOutputDirection());
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockPanelController) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockPanelController.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront().func_176746_e().func_176746_e();
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricOutputDirection();
        }
        return false;
    }

    @Override
    public void setEffectsVisible(boolean shouldRender) {
        this.visible = shouldRender;
    }

    @Override
    public boolean getEffectsVisible() {
        return this.visible;
    }
}

