/*
 * Decompiled with CFR 0.152.
 */
package net.slayer5934.chococraft.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.slayer5934.chococraft.Chococraft;
import net.slayer5934.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.slayer5934.chococraft.common.entities.breeding.ChocoboStatSnapshot;
import net.slayer5934.chococraft.common.init.ModBlocks;
import net.slayer5934.chococraft.common.tileentities.TileEntityChocoboEgg;
import net.slayer5934.chococraft.utils.inject.AttachedTileEntity;
import net.slayer5934.chococraft.utils.registration.IItemBlockProvider;

@AttachedTileEntity(name="chocobo_egg", tile=TileEntityChocoboEgg.class)
public class BlockChocoboEgg
extends Block
implements IItemBlockProvider {
    public static final String NBTKEY_HATCHINGSTATE_TIME = "Time";
    public static final String NBTKEY_HATCHINGSTATE = "HatchingState";
    public static final String NBTKEY_BREEDINFO = "BreedInfo";
    public static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);

    public BlockChocoboEgg() {
        super(Material.field_151578_c);
        this.setHarvestLevel("pickaxe", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static boolean isChocoboEgg(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() instanceof BlockChocoboEgg;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityChocoboEgg();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (!(tile instanceof TileEntityChocoboEgg)) {
                return;
            }
            ChocoboBreedInfo breedInfo = ChocoboBreedInfo.getFromNbtOrDefault(stack.func_179543_a(NBTKEY_BREEDINFO));
            ((TileEntityChocoboEgg)tile).setBreedInfo(breedInfo);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityChocoboEgg) {
            if (worldIn.field_72995_K) {
                return;
            }
            player.func_71029_a(StatList.func_188055_a((Block)this));
            player.func_71020_j(0.005f);
            ItemStack itemStack = new ItemStack((Block)ModBlocks.chocoboEgg, 1, 0);
            ChocoboBreedInfo breedInfo = ((TileEntityChocoboEgg)te).getBreedInfo();
            if (breedInfo == null) {
                Chococraft.log.error("Unable to create ItemStack for egg @ {}, the eggy has no breeding info attached");
                return;
            }
            if (breedInfo != null) {
                itemStack.func_77983_a(NBTKEY_BREEDINFO, (NBTBase)breedInfo.serialize());
            }
            BlockChocoboEgg.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemStack);
            return;
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound nbt = stack.func_179543_a(NBTKEY_BREEDINFO);
        if (nbt != null) {
            ChocoboBreedInfo info = new ChocoboBreedInfo(nbt);
            ChocoboStatSnapshot mother = info.getMother();
            ChocoboStatSnapshot father = info.getFather();
            tooltip.add(I18n.func_135052_a((String)"item.chococraft.chocobo_egg.tooltip.mother_info", (Object[])new Object[]{(int)mother.health, (int)(mother.speed * 100.0f), (int)mother.stamina}));
            tooltip.add(I18n.func_135052_a((String)"item.chococraft.chocobo_egg.tooltip.father_info", (Object[])new Object[]{(int)father.health, (int)(father.speed * 100.0f), (int)father.stamina}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"item.chococraft.chocobo_egg.tooltip.invalid_egg", (Object[])new Object[0]));
        }
    }
}

