/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.controls;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.client.style.Style;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;

public class GuiLTDistance
extends GuiParent {
    public GuiLTDistance(String name, int x, int y, LittleGridContext context, int distance) {
        super(name, x, y, 72, 12);
        this.marginWidth = 0;
        this.borderWidth = 0;
        this.addControl(new GuiTextfield("blocks", "", 0, 0, 20, 12).setNumbersIncludingNegativeOnly().setCustomTooltip(new String[]{"blocks"}));
        GuiStateButton contextBox = new GuiStateButton("grid", LittleGridContext.getNames().indexOf(context + ""), 30, 0, 15, 12, LittleGridContext.getNames().toArray(new String[0]));
        this.addControl((GuiControl)contextBox);
        this.addControl(new GuiTextfield("ltdistance", "", 52, 0, 20, 12).setNumbersIncludingNegativeOnly().setCustomTooltip(new String[]{"grid distance"}));
        this.setStyle(Style.emptyStyleDisabled);
        this.setDistance(context, distance);
    }

    public boolean hasStyle() {
        return false;
    }

    public boolean raiseEvent(ControlEvent event) {
        if (event instanceof GuiControlChangedEvent) {
            super.raiseEvent((ControlEvent)new GuiControlChangedEvent((GuiControl)this));
        }
        return super.raiseEvent(event);
    }

    public void resetTextfield() {
        ((GuiTextfield)this.get("blocks")).setCursorPositionZero();
        ((GuiTextfield)this.get("ltdistance")).setCursorPositionZero();
    }

    public void setDistance(LittleGridContext context, int distance) {
        GuiStateButton contextBox = (GuiStateButton)this.get("grid");
        contextBox.setState(LittleGridContext.getNames().indexOf(context + ""));
        int blocks = distance / context.size;
        GuiTextfield blocksTF = (GuiTextfield)this.get("blocks");
        blocksTF.text = "" + blocks;
        blocksTF.setCursorPositionZero();
        GuiTextfield ltdistanceTF = (GuiTextfield)this.get("ltdistance");
        ltdistanceTF.text = "" + (distance - blocks * context.size);
        ltdistanceTF.setCursorPositionZero();
    }

    public int getDistance() {
        GuiTextfield blocksTF = (GuiTextfield)this.get("blocks");
        GuiTextfield ltdistanceTF = (GuiTextfield)this.get("ltdistance");
        LittleGridContext context = this.getDistanceContext();
        try {
            return Integer.parseInt(blocksTF.text) * context.size + Integer.parseInt(ltdistanceTF.text);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public LittleGridContext getDistanceContext() {
        GuiStateButton contextBox = (GuiStateButton)this.get("grid");
        try {
            return LittleGridContext.get(Integer.parseInt(contextBox.caption));
        }
        catch (NumberFormatException e) {
            return LittleGridContext.get();
        }
    }
}

