/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.handler;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleGuiHandler
extends CustomGuiHandler {
    public static void openGui(String id, NBTTagCompound nbt, EntityPlayer player, LittleTile tile) {
        new LittleTileIdentifierAbsolute(tile).writeToNBT(nbt);
        if (tile.te.func_145831_w() instanceof CreativeWorld) {
            nbt.func_74778_a("uuid", ((CreativeWorld)tile.te.func_145831_w()).parent.func_110124_au().toString());
        }
        GuiHandler.openGui((String)id, (NBTTagCompound)nbt, (EntityPlayer)player);
    }

    public World getWorld(NBTTagCompound nbt, EntityPlayer player) {
        if (nbt.func_74764_b("uuid")) {
            EntityAnimation animation = LittleDoorHandler.getHandler(player.field_70170_p.field_72995_K).findDoor(UUID.fromString(nbt.func_74779_i("uuid")));
            if (animation != null) {
                return animation.fakeWorld;
            }
            throw new RuntimeException("Could not find world " + nbt.func_74779_i("uuid"));
        }
        return player.field_70170_p;
    }

    public abstract SubContainer getContainer(EntityPlayer var1, NBTTagCompound var2, LittleTile var3);

    public SubContainer getContainer(EntityPlayer player, NBTTagCompound nbt) {
        try {
            return this.getContainer(player, nbt, LittleAction.getTile(this.getWorld(nbt, player), new LittleTileIdentifierAbsolute(nbt)));
        }
        catch (LittleActionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract SubGui getGui(EntityPlayer var1, NBTTagCompound var2, LittleTile var3);

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, NBTTagCompound nbt) {
        try {
            return this.getGui(player, nbt, LittleAction.getTile(this.getWorld(nbt, player), new LittleTileIdentifierAbsolute(nbt)));
        }
        catch (LittleActionException e) {
            e.printStackTrace();
            return null;
        }
    }
}

