/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.overlay;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.client.render.cache.RenderingThread;
import com.google.common.base.Strings;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class LittleTilesProfilerOverlay {
    public static boolean showDebugInfo = false;
    public static int vanillaChunksUpdates = 0;
    public static int ltChunksUpdates = 0;
    public static int uploaded = 0;
    private static int updateTime = 20;
    private static int updateTicker = 0;
    private static DecimalFormat df = new DecimalFormat("0.##");
    private static Minecraft mc = Minecraft.func_71410_x();

    private static String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private static String format(PairList<String, Object> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            builder.append(ChatFormatting.YELLOW + (String)pair.key + ChatFormatting.RESET + ":" + LittleTilesProfilerOverlay.format(pair.value));
        }
        return builder.toString();
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++updateTicker > updateTime) {
            vanillaChunksUpdates = 0;
            ltChunksUpdates = 0;
            uploaded = 0;
            updateTicker = 0;
        }
    }

    @SubscribeEvent
    public static void onRender(TickEvent.RenderTickEvent event) {
        if (showDebugInfo && event.phase == TickEvent.Phase.END && LittleTilesProfilerOverlay.mc.field_71415_G && !LittleTilesProfilerOverlay.mc.field_71474_y.field_74319_N) {
            GlStateManager.func_179094_E();
            ArrayList<String> list = new ArrayList<String>();
            PairList details = new PairList();
            details.add((Object)"ThreadCount", (Object)RenderingThread.threads.size());
            details.add((Object)"Chunks", (Object)RenderingThread.chunks.size());
            details.add((Object)"Triggered", (Object)(uploaded + "(" + vanillaChunksUpdates + ")/" + ltChunksUpdates));
            int queued = 0;
            for (RenderingThread thread : RenderingThread.threads) {
                if (thread == null) continue;
                queued += thread.updateCoords.size();
            }
            details.add((Object)"Queue", (Object)queued);
            for (RenderingThread thread : RenderingThread.threads) {
                if (thread == null) continue;
                details.add((Object)("" + thread.getThreadIndex()), (Object)thread.updateCoords.size());
            }
            list.add(LittleTilesProfilerOverlay.format((PairList<String, Object>)details));
            details.clear();
            for (int i = 0; i < list.size(); ++i) {
                String s = (String)list.get(i);
                if (Strings.isNullOrEmpty((String)s)) continue;
                int j = LittleTilesProfilerOverlay.mc.field_71466_p.field_78288_b;
                int k = LittleTilesProfilerOverlay.mc.field_71466_p.func_78256_a(s);
                int l = 2;
                int i1 = 2 + j * i;
                Gui.func_73734_a((int)1, (int)(i1 - 1), (int)(2 + k + 1), (int)(i1 + j - 1), (int)-1873784752);
                LittleTilesProfilerOverlay.mc.field_71466_p.func_78276_b(s, 2, i1, 0xE0E0E0);
            }
            GlStateManager.func_179121_F();
        }
    }
}

