/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.overlay;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.GuiRenderHelper;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.gui.controls.GuiActionDisplay;
import com.creativemd.littletiles.client.render.overlay.OverlayControl;
import com.creativemd.littletiles.client.render.overlay.OverlayGui;
import com.creativemd.littletiles.common.utils.tooltip.ActionMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class OverlayRenderer {
    private static Minecraft mc = Minecraft.func_71410_x();
    protected static ScaledResolution scaledResolution;
    private OverlayGui gui = new OverlayGui();
    private GuiActionDisplay actionDisplay = new GuiActionDisplay("action", 0, 0, 100).setMessageCount(1).setLinesCount(4);

    public OverlayRenderer() {
        this.add(new OverlayControl(this.actionDisplay, OverlayPositionType.ACTION_BAR){

            @Override
            public void resize() {
                super.resize();
                this.control.width = this.parent.width;
            }
        });
    }

    public void addMessage(ActionMessage message) {
        this.actionDisplay.addMessage(message);
    }

    public void add(OverlayControl control) {
        this.gui.add(control);
    }

    @SubscribeEvent
    public void render(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && OverlayRenderer.mc.field_71439_g != null && OverlayRenderer.mc.field_71415_G) {
            scaledResolution = new ScaledResolution(mc);
            if (this.gui.width != scaledResolution.func_78326_a() || this.gui.height != scaledResolution.func_78328_b()) {
                this.gui.width = scaledResolution.func_78326_a();
                this.gui.height = scaledResolution.func_78328_b();
                this.gui.resize();
            }
            GL11.glDisable((int)2960);
            GL11.glStencilMask((int)-1);
            GL11.glClear((int)1024);
            GL11.glStencilFunc((int)519, (int)1, (int)1);
            GL11.glStencilOp((int)7681, (int)7681, (int)7681);
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.renderControl(GuiRenderHelper.instance, 1.0f, GuiControl.getScreenRect());
            GlStateManager.func_179121_F();
            GL11.glClear((int)1024);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && OverlayRenderer.mc.field_71439_g != null && OverlayRenderer.mc.field_71415_G) {
            this.gui.onTick();
        }
    }

    public static enum OverlayPositionType {
        CENTER{

            @Override
            protected void positionControl(GuiControl control, int width, int height) {
                control.posX = width / 2 - control.width / 2;
                control.posY = height / 2 - control.height / 2;
            }
        }
        ,
        ACTION_BAR{

            @Override
            protected void positionControl(GuiControl control, int width, int height) {
                control.posX = width / 2 - control.width / 2;
                control.posY = height - control.height - 68;
            }
        };


        protected abstract void positionControl(GuiControl var1, int var2, int var3);

        public void positionControl(GuiControl control) {
            if (scaledResolution != null) {
                this.positionControl(control, scaledResolution.func_78326_a() - LittleTilesClient.overlay.gui.getContentOffset() * 2, scaledResolution.func_78328_b() - LittleTilesClient.overlay.gui.getContentOffset() * 2);
            }
        }
    }
}

